/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.common;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbd.common.AccSysHelper;
import kd.tmc.fbd.common.MonHelper;

public class OrgHelper {
    private static String selectFields = "basecurrency.id baseCurrencyID,exratetable.id exratetable";

    public static Set<Long> getSubOrg(Long orgId, Set<Long> orgIds) {
        return orgIds;
    }

    public static Long getMainCurrency(long orgId) {
        return Optional.ofNullable(OrgHelper.getBankInfo(orgId)).map(v -> (Long)v.get("baseCurrencyID")).orElse(0L);
    }

    public static Long getExrateTable(long orgId) {
        return Optional.ofNullable(OrgHelper.getBankInfo(orgId)).map(v -> (Long)v.get("exchangeRateTableID")).orElse(0L);
    }

    public static Map<String, Long> getBankInfo(long orgId) {
        Map<String, Long> baseAccountingInfo = OrgHelper.getBookInfoByAccSys(orgId);
        if (baseAccountingInfo.size() < 1) {
            baseAccountingInfo = AccSysHelper.getBaseAccountingInfo(orgId);
        }
        return baseAccountingInfo;
    }

    public static Map<String, Long> getBookInfoByAccSys(long accorg) {
        QFilter h = new QFilter("org.id", "=", (Object)accorg);
        QFilter k = new QFilter("bookstype.accounttype", "=", (Object)"1");
        DynamicObject accountBooksInfo = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)selectFields, (QFilter[])new QFilter[]{k, h});
        HashMap<String, Long> map = new HashMap<String, Long>();
        if (!MonHelper.isEmpty(accountBooksInfo)) {
            map.put("baseCurrencyID", accountBooksInfo.getLong("baseCurrencyID"));
            map.put("exchangeRateTableID", accountBooksInfo.getLong("exratetable"));
        }
        return map;
    }
}

