/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.common.helper;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.tmc.fbd.common.enums.FbdEntityEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BusinessHelper {
    public static void delPushRecPayBill(DynamicObject data) {
        Map botpMap = BFTrackerServiceHelper.findTargetBills((String)data.getDynamicObjectType().getName(), (Long[])new Long[]{data.getLong("id")});
        botpMap.forEach((entity, id) -> {
            if ("cas_recbill".equals(entity) || "cas_paybill".equals(entity)) {
                try (TXHandle tx = TX.requiresNew();){
                    OperateOption operateOption = OperateOption.create();
                    operateOption.setVariableValue("isdelbypaysche", "1");
                    TmcOperateServiceHelper.execOperate((String)"delete", (String)entity, (Object[])id.toArray(), (OperateOption)operateOption);
                }
            }
        });
    }

    public static String checkTargetBill(String entityName, Long billId, String targetEntityName) {
        StringBuilder msg = new StringBuilder();
        DynamicObject targetBill = TmcBotpHelper.getTargetBill((String)entityName, (Object)billId, (String)targetEntityName);
        if (EmptyUtil.isNoEmpty((DynamicObject)targetBill)) {
            String targetBillName = FbdEntityEnum.getName(targetEntityName);
            String billNo = targetBill.getString("billno");
            String existBillsMsg = String.format(ResManager.loadKDString((String)"%1$s\u5355\u636e[%2$s]\uff1b", (String)"BusinessHelper_1", (String)"tmc-fbd-common", (Object[])new Object[0]), StringUtils.isBlank((CharSequence)targetBillName) ? targetEntityName : targetBillName, billNo);
            msg.append(existBillsMsg);
        }
        if (msg.length() > 0) {
            msg.insert(0, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5df2\u5b58\u5728\u4e0b\u6e38\u5355\u636e\u3002\u3002", (String)"BusinessHelper_0", (String)"tmc-fbd-common", (Object[])new Object[0]));
        }
        return msg.toString();
    }

    public static String checkTargetBills(String entityName, Long billId) {
        StringBuilder msg = new StringBuilder();
        Map botpMap = BFTrackerServiceHelper.findTargetBills((String)entityName, (Long[])new Long[]{billId});
        if (botpMap != null && botpMap.size() > 0) {
            for (Map.Entry entry : botpMap.entrySet()) {
                String existBillsMsg = BusinessHelper.getExistBillsMsg((String)entry.getKey(), (HashSet)entry.getValue());
                msg.append(existBillsMsg);
            }
        }
        if (msg.length() > 0) {
            msg.insert(0, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5df2\u5b58\u5728\u4e0b\u6e38\u5355\u636e\u3002\u3002", (String)"BusinessHelper_0", (String)"tmc-fbd-common", (Object[])new Object[0]));
        }
        return msg.toString();
    }

    private static String getExistBillsMsg(String targetEntityName, HashSet<Long> targetBillIds) {
        DynamicObjectCollection targetBills = QueryServiceHelper.query((String)targetEntityName, (String)"billno", (QFilter[])new QFilter[]{new QFilter("id", "in", targetBillIds)});
        if (targetBills == null || targetBills.size() <= 0) {
            return "";
        }
        List billnos = targetBills.stream().map(v -> v.getString("billno")).collect(Collectors.toList());
        String targetBillName = FbdEntityEnum.getName(targetEntityName);
        return String.format(ResManager.loadKDString((String)"%1$s\u5355\u636e[%2$s]\uff1b", (String)"BusinessHelper_1", (String)"tmc-fbd-common", (Object[])new Object[0]), StringUtils.isBlank((CharSequence)targetBillName) ? targetEntityName : targetBillName, String.join((CharSequence)",", billnos));
    }
}

