/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.common.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.org.model.OrgParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbd.common.constant.CompanySysViewConst;
import kd.tmc.fbp.common.enums.CompanySysAuthTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class CompanySysViewHelper {
    public static void appendCompanySysViewAuth(List<Long> pkIdList, List<Long> userIds, List<String> roleIds) {
        CompanySysViewHelper.mergeCompanySysViewAuth(pkIdList, userIds, roleIds, true, null);
    }

    public static void mergeCompanySysViewAuth(List<Long> pkIdList, List<Long> userIds, List<String> roleIds, Long defUser) {
        CompanySysViewHelper.mergeCompanySysViewAuth(pkIdList, userIds, roleIds, false, defUser);
    }

    private static void mergeCompanySysViewAuth(List<Long> pkIdList, List<Long> userIds, List<String> roleIds, boolean isAppend, Long defUser) {
        DynamicObjectCollection vs = QueryServiceHelper.query((String)"fbd_companysysauth", (String)StringUtils.join((Object[])new String[]{"id", "authtype", "authuser.id", "authrole.id", "companysysview.id"}, (String)","), (QFilter[])new QFilter[]{new QFilter("companysysview", "in", pkIdList)}, null);
        ArrayList authList = new ArrayList(10);
        ArrayList toDelete = isAppend ? new ArrayList(10) : vs.stream().map(t -> t.getLong("id")).collect(Collectors.toList());
        for (Long pkId : pkIdList) {
            List temp;
            if (CollectionUtils.isNotEmpty(userIds)) {
                Map<Long, Long> userMap = vs.stream().filter(t -> CompanySysAuthTypeEnum.USER.getValue().equals(t.getString("authtype")) && pkId.equals(t.getLong("companysysview.id"))).collect(Collectors.toMap(t -> t.getLong("authuser.id"), t -> t.getLong("id"), (p, q) -> p));
                temp = userIds.stream().filter(uid -> {
                    toDelete.remove(userMap.get(uid));
                    return !userMap.containsKey(uid);
                }).map(t -> {
                    DynamicObject userObj = BusinessDataServiceHelper.newDynamicObject((String)"fbd_companysysauth");
                    userObj.set("companysysview", (Object)pkId);
                    userObj.set("authtype", (Object)CompanySysAuthTypeEnum.USER.getValue());
                    userObj.set("authuser", t);
                    if (!isAppend && defUser.equals(t)) {
                        userObj.set("defaultuser", (Object)"D");
                    } else {
                        userObj.set("defaultuser", (Object)"N");
                    }
                    return userObj;
                }).collect(Collectors.toList());
                authList.addAll(temp);
            }
            if (!CollectionUtils.isNotEmpty(roleIds)) continue;
            Map<String, Long> roleMap = vs.stream().filter(t -> CompanySysAuthTypeEnum.ROLE.getValue().equals(t.getString("authtype")) && pkId.equals(t.getLong("companysysview.id"))).collect(Collectors.toMap(t -> t.getString("authrole.id"), t -> t.getLong("id"), (p, q) -> p));
            temp = roleIds.stream().filter(roleId -> {
                toDelete.remove(roleMap.get(roleId));
                return !roleMap.containsKey(roleId);
            }).map(t -> {
                DynamicObject roleObj = BusinessDataServiceHelper.newDynamicObject((String)"fbd_companysysauth");
                roleObj.set("companysysview", (Object)pkId);
                roleObj.set("authtype", (Object)CompanySysAuthTypeEnum.ROLE.getValue());
                roleObj.set("authrole", t);
                roleObj.set("defaultuser", (Object)"N");
                return roleObj;
            }).collect(Collectors.toList());
            authList.addAll(temp);
        }
        if (CollectionUtils.isNotEmpty(authList)) {
            TmcDataServiceHelper.save((DynamicObject[])authList.toArray(new DynamicObject[0]));
        }
        if (CollectionUtils.isNotEmpty(toDelete)) {
            DeleteServiceHelper.delete((String)"fbd_companysysauth", (QFilter[])new QFilter[]{new QFilter("id", "in", toDelete)});
        }
    }

    public static void modifyCompanyView(List<Long> views, Long modifyId) {
        QFilter viewFilter = new QFilter("id", "in", views);
        String propertis = StringUtils.join((Object[])new String[]{"id", "modifier", "modifytime"}, (String)",");
        DynamicObject[] viewObj = TmcDataServiceHelper.load((String)"fbd_companysysviewsch", (String)propertis, (QFilter[])new QFilter[]{viewFilter});
        Date now = new Date();
        for (DynamicObject obj : viewObj) {
            obj.set("modifier", (Object)modifyId);
            obj.set("modifytime", (Object)now);
        }
        TmcDataServiceHelper.save((DynamicObject[])viewObj);
    }

    public static boolean idDefaultViewId(Long viewId) {
        if (Objects.isNull(viewId)) {
            return false;
        }
        return CompanySysViewConst.DEFAULT_FUN_ORG_VIEW_ID.equals(viewId);
    }

    public static void syncOrgUnitDuty(List<OrgParam> delParams, List<Tuple<Integer, OrgParam>> addParams) {
        if (CollectionUtils.isNotEmpty(delParams)) {
            OrgUnitServiceHelper.deleteDuty(delParams);
        }
        if (CollectionUtils.isNotEmpty(addParams)) {
            Map<Integer, List<Tuple>> groupMap = addParams.stream().collect(Collectors.groupingBy(t -> (Integer)t.item1));
            List levels = groupMap.keySet().stream().sorted(Integer::compareTo).collect(Collectors.toList());
            for (Integer level : levels) {
                List list = groupMap.get(level).stream().map(t -> (OrgParam)t.item2).collect(Collectors.toList());
                OrgUnitServiceHelper.addDuty(list);
            }
            delParams.addAll(addParams.stream().map(t -> (OrgParam)t.item2).collect(Collectors.toList()));
        }
    }
}

