/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbd.common.bean.FloatRateCalBean;
import kd.tmc.fbd.common.bean.RateAdjustBean;
import kd.tmc.fbd.common.enums.RateAdjustStyleEnum;
import kd.tmc.fbd.common.helper.SuretyHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.RateSignEnum;
import kd.tmc.fbp.common.helper.MarketDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FbdRateAdjustHelper {
    private static final Log logger = LogFactory.getLog(FbdRateAdjustHelper.class);

    private FbdRateAdjustHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static void updateRateAdjustList(DynamicObject suretyBill, Map<String, String> operationVariable) {
        DynamicObjectCollection rateAdjustEntry = suretyBill.getDynamicObjectCollection("rateadjust_entry");
        if (!"true".equals(operationVariable.get("hand"))) {
            rateAdjustEntry.clear();
        }
        List<Object> rateAdjustList = new ArrayList(10);
        if (CollectionUtils.isEmpty((Collection)rateAdjustEntry)) {
            rateAdjustList = FbdRateAdjustHelper.getRateAdjustList(suretyBill);
        }
        if (EmptyUtil.isNoEmpty(rateAdjustList)) {
            rateAdjustEntry.clear();
            int seq = 1;
            rateAdjustList.sort(Comparator.comparing(RateAdjustBean::getEffectDate));
            for (RateAdjustBean rateAdjustBean : rateAdjustList) {
                DynamicObject rateAdjustEntryDo = rateAdjustEntry.addNew();
                rateAdjustEntryDo.set("seq", (Object)seq++);
                rateAdjustEntryDo.set("ra_confirmdate", (Object)rateAdjustBean.getConfirmDate());
                rateAdjustEntryDo.set("ra_effectdate", (Object)rateAdjustBean.getEffectDate());
                rateAdjustEntryDo.set("ra_yearrate", (Object)rateAdjustBean.getYearRate());
                rateAdjustEntryDo.set("ra_remark", (Object)rateAdjustBean.getRemark());
                rateAdjustEntryDo.set("ra_modifier", (Object)rateAdjustBean.getModifier());
                rateAdjustEntryDo.set("ra_modifydate", (Object)rateAdjustBean.getModifyDate());
            }
        }
    }

    private static List<RateAdjustBean> getRateAdjustList(DynamicObject suretyBill) {
        ArrayList<RateAdjustBean> rateAdjustBeanList = new ArrayList<RateAdjustBean>(10);
        Date actStartIntDate = suretyBill.getDate("intdate");
        String interestType = suretyBill.getString("interesttype");
        if (EmptyUtil.isEmpty((Object)suretyBill.getDate("expiredate")) || InterestTypeEnum.FIXED.getValue().equals(interestType)) {
            logger.info("interesttype-->fixed");
            Date bizDate = suretyBill.getDate("bizdate");
            if (EmptyUtil.isNoEmpty((Object)bizDate) && bizDate.before(actStartIntDate)) {
                actStartIntDate = bizDate;
            }
            logger.info("interesttype-->fixedactStartIntDate: " + actStartIntDate);
            BigDecimal fixedRate = EmptyUtil.isNoEmpty((Object)suretyBill.getDate("expiredate")) ? suretyBill.getBigDecimal("interestrate") : suretyBill.getBigDecimal("demandrate");
            FbdRateAdjustHelper.definListAdd(rateAdjustBeanList, new RateAdjustBean(actStartIntDate, actStartIntDate, fixedRate));
        } else if (InterestTypeEnum.FLOAT.getValue().equals(interestType)) {
            logger.info("interesttype-->float");
            FloatRateCalBean floatRateSegBean = FbdRateAdjustHelper.buildFloatRateCalBean(suretyBill, actStartIntDate);
            FbdRateAdjustHelper.dealRowAdjustRate(rateAdjustBeanList, floatRateSegBean);
        }
        return rateAdjustBeanList;
    }

    private static void definListAdd(List<RateAdjustBean> rateAdjustBeanList, RateAdjustBean needAddObj) {
        List theSameRateAdjusts;
        if (EmptyUtil.isNoEmpty(rateAdjustBeanList) && EmptyUtil.isNoEmpty(theSameRateAdjusts = rateAdjustBeanList.stream().filter(o -> o.getEffectDate().compareTo(needAddObj.getEffectDate()) == 0).collect(Collectors.toList()))) {
            rateAdjustBeanList.removeAll(theSameRateAdjusts);
        }
        rateAdjustBeanList.add(needAddObj);
    }

    private static FloatRateCalBean buildFloatRateCalBean(DynamicObject suretyBill, Date beginDate) {
        String rateAdjustStyle = suretyBill.getString("rateadjuststyle");
        Date endDate = suretyBill.getDate("expiredate");
        FloatRateCalBean floatRate = new FloatRateCalBean();
        floatRate.setConfirmDate(beginDate);
        floatRate.setStartDate(beginDate);
        floatRate.setEndDate(endDate);
        floatRate.setRefrateNum(suretyBill.getDynamicObject("referencerate").getString("number"));
        floatRate.setRateAdjustStyle(rateAdjustStyle);
        floatRate.setRateSign(suretyBill.getString("ratesign"));
        floatRate.setRateBasePoint(suretyBill.getBigDecimal("ratefloatpoint"));
        return floatRate;
    }

    private static void dealRowAdjustRate(List<RateAdjustBean> rateAdjustBeanList, FloatRateCalBean floatRateSegBean) {
        BigDecimal firstEffectYearRate;
        logger.info("before dealRowAdjustRate rateAdjustBeanList size" + rateAdjustBeanList.size());
        Date endDate = floatRateSegBean.getEndDate();
        Date beginConfirmDate = floatRateSegBean.getConfirmDate();
        Map rateDatas = MarketDataServiceHelper.referRate((String)floatRateSegBean.getRefrateNum(), (Date)beginConfirmDate, (Date)endDate);
        logger.info("dealRowAdjustRate MarketDataServiceHelper.referRate size" + rateDatas.size());
        if (EmptyUtil.isEmpty((Object)rateDatas)) {
            SuretyHelper.refferRateNotExistException();
        }
        String rateSign = floatRateSegBean.getRateSign();
        BigDecimal rateFloatPoint = floatRateSegBean.getRateBasePoint();
        BigDecimal rateFloat = rateFloatPoint.divide(Constants.ONE_HUNDRED, 20, RoundingMode.HALF_UP);
        if (RateSignEnum.SUBTRACT.getValue().equals(rateSign)) {
            rateFloat = rateFloat.negate();
        }
        if (EmptyUtil.isEmpty((BigDecimal)(firstEffectYearRate = FbdRateAdjustHelper.getEffectYearRate(rateDatas, beginConfirmDate, rateFloat)))) {
            SuretyHelper.refferRateNotExistException();
        }
        FbdRateAdjustHelper.definListAdd(rateAdjustBeanList, new RateAdjustBean(floatRateSegBean.getStartDate(), beginConfirmDate, firstEffectYearRate));
        boolean endDateIsNull = EmptyUtil.isEmpty((Object)endDate);
        String rateAdjustStyle = floatRateSegBean.getRateAdjustStyle();
        if (RateAdjustStyleEnum.DEADLINE.getValue().equals(rateAdjustStyle)) {
            TreeMap deadLineRates = new TreeMap(Date::compareTo);
            for (Map.Entry entry : rateDatas.entrySet()) {
                Date key = (Date)entry.getKey();
                if (key.compareTo(beginConfirmDate) <= 0 || !endDateIsNull && key.compareTo(endDate) >= 0) continue;
                deadLineRates.put(key, entry.getValue());
            }
            logger.info("dealRowAdjustRate deadLineRates size" + deadLineRates.size());
            if (!deadLineRates.isEmpty()) {
                BigDecimal tempRate = rateAdjustBeanList.get(0).getYearRate().subtract(rateFloat);
                for (Map.Entry entry : deadLineRates.entrySet()) {
                    if (((BigDecimal)entry.getValue()).compareTo(tempRate) == 0) continue;
                    tempRate = (BigDecimal)entry.getValue();
                    Date confirmDate = (Date)entry.getKey();
                    FbdRateAdjustHelper.definListAdd(rateAdjustBeanList, new RateAdjustBean(confirmDate, confirmDate, tempRate.add(rateFloat)));
                }
            }
        }
        logger.info("after dealRowAdjustRate rateAdjustBeanList size" + rateAdjustBeanList.size());
    }

    private static BigDecimal getEffectYearRate(Map<Date, BigDecimal> refRates, Date effectRate, BigDecimal rateFloatPoint) {
        AtomicReference<BigDecimal> rate = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        refRates.entrySet().stream().filter(o -> ((Date)o.getKey()).compareTo(effectRate) <= 0).max(Comparator.comparing(Map.Entry::getKey)).ifPresent(o -> rate.set(((BigDecimal)o.getValue()).add(rateFloatPoint)));
        return rate.get();
    }
}

