/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.common.helper;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbd.common.enums.IntDataSource;
import kd.tmc.fbd.common.enums.PreIntOperateTypeEnum;
import kd.tmc.fbd.common.enums.RevenueStatEnum;
import kd.tmc.fbd.common.enums.RevenueTypeEnum;
import kd.tmc.fbd.common.enums.RevenueWayEnum;
import kd.tmc.fbd.common.enums.WriteOffStatusEnum;
import kd.tmc.fbd.common.helper.FbdRateAdjustHelper;
import kd.tmc.fbd.common.helper.SuretyIntCalcHelper;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class RevenuePlanCalHelper {
    private static final String SURETY_SETTLE_INT_PROP = "id,actpreinstamt,revenuetype,prestenddate,bizdate,entrys.inststartdate,entrys.instenddate,entrys.instdays,entrys.instprincipalamt,entrys.rate,entrys.ratetrandays,entrys.instamt";

    public static void calRevenuePlan(Long suretyBillId, String entity, Map<String, String> operationVariable) {
        DynamicObject suretyBill = TmcDataServiceHelper.loadSingle((Object)suretyBillId, (String)"fbd_suretybill");
        if (EmptyUtil.isEmpty((DynamicObject)suretyBill)) {
            return;
        }
        if (RevenueWayEnum.NOREVENUE.getValue().equals(suretyBill.getString("revenueway"))) {
            suretyBill.getDynamicObjectCollection("revenue_entry").clear();
            suretyBill.getDynamicObjectCollection("rateadjust_entry").clear();
            SaveServiceHelper.save((IDataEntityType)suretyBill.getDataEntityType(), (Object[])new DynamicObject[]{suretyBill});
            return;
        }
        if ("fbd_surety_settleint".equals(entity)) {
            RevenuePlanCalHelper.interestBillDo(suretyBill);
        }
        DynamicObjectCollection revenueEntries = suretyBill.getDynamicObjectCollection("revenue_entry");
        revenueEntries.clear();
        boolean noRelease = RevenuePlanCalHelper.dealRealRevenuePartWriteBack(suretyBill);
        FbdRateAdjustHelper.updateRateAdjustList(suretyBill, operationVariable);
        if (noRelease) {
            Pair<BigDecimal, List<IntBillInfo>> intBills = SuretyIntCalcHelper.callIntPlan(suretyBill);
            RevenuePlanCalHelper.suretyBillWriteBack(intBills, suretyBill);
        }
        SaveServiceHelper.save((IDataEntityType)suretyBill.getDataEntityType(), (Object[])new DynamicObject[]{suretyBill});
    }

    private static boolean dealRealRevenuePartWriteBack(DynamicObject suretyBill) {
        Object[] revenueBills = RevenuePlanCalHelper.getSettleIntBill(suretyBill);
        if (EmptyUtil.isEmpty((Object[])revenueBills)) {
            return true;
        }
        DynamicObjectCollection revenueEntry = suretyBill.getDynamicObjectCollection("revenue_entry");
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (int i = 0; i < revenueBills.length; ++i) {
            Object revenueBill = revenueBills[i];
            DynamicObject revenueRow = revenueEntry.addNew();
            revenueRow.set("seq", (Object)(i + 1));
            revenueRow.set("revenueseq", (Object)(i + 1));
            revenueRow.set("revenuetype", (Object)revenueBill.getString("revenuetype"));
            revenueRow.set("revenuedate", (Object)revenueBill.getDate("bizdate"));
            revenueRow.set("revenuecalamount", (Object)revenueBill.getBigDecimal("actpreinstamt"));
            revenueRow.set("revenuestate", (Object)RevenueStatEnum.DONE.getValue());
            DynamicObjectCollection revenueSubEntry = revenueRow.getDynamicObjectCollection("revenue_subentry");
            revenueSubEntry.clear();
            DynamicObjectCollection revenueEntries = revenueBill.getDynamicObjectCollection("entrys");
            for (int j = 0; j < revenueEntries.size(); ++j) {
                DynamicObject realRevRow = (DynamicObject)revenueEntries.get(j);
                DynamicObject revenueSubRow = revenueSubEntry.addNew();
                revenueSubRow.set("seq", (Object)(j + 1));
                revenueSubRow.set("startdate", (Object)realRevRow.getDate("inststartdate"));
                revenueSubRow.set("enddate", (Object)realRevRow.getDate("instenddate"));
                revenueSubRow.set("days", (Object)realRevRow.getInt("instdays"));
                revenueSubRow.set("finamount", (Object)realRevRow.getBigDecimal("instprincipalamt"));
                revenueSubRow.set("eplanrevenue", (Object)realRevRow.getBigDecimal("rate"));
                revenueSubRow.set("convertdays", (Object)realRevRow.getBigDecimal("ratetrandays"));
                revenueSubRow.set("erevenueamount", (Object)realRevRow.getBigDecimal("instamt"));
                totalAmount = totalAmount.add(revenueSubRow.getBigDecimal("finamount"));
            }
        }
        return totalAmount.compareTo(suretyBill.getBigDecimal("amount")) < 0;
    }

    private static void interestBillDo(DynamicObject suretyBill) {
        QFilter qFilter = new QFilter("loanbillno", "=", (Object)suretyBill.getString("billno"));
        qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and("datasource", "=", (Object)IntDataSource.SETTLEINT.getValue());
        DynamicObjectCollection revenueBills = QueryServiceHelper.query((String)"fbd_surety_settleint", (String)"id,actpreinstamt,revenuetype,prestenddate", (QFilter[])qFilter.toArray(), (String)"expiredate desc");
        BigDecimal totalAmount = revenueBills.stream().map(s -> s.getBigDecimal("actpreinstamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        DynamicObject revBill = null;
        Date endDate = null;
        for (DynamicObject revenueBill : revenueBills) {
            if (revBill == null && RevenueTypeEnum.REVENUE.getValue().equals(revenueBill.getString("revenuetype"))) {
                revBill = revenueBill;
            }
            endDate = revBill == null ? null : revBill.getDate("prestenddate");
        }
        suretyBill.set("endinstdate", endDate);
        suretyBill.set("totalamount", (Object)totalAmount);
    }

    private static DynamicObject[] getSettleIntBill(DynamicObject suretyBill) {
        QFilter qFilter = new QFilter("loanbillno", "=", (Object)suretyBill.getString("billno"));
        qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and("datasource", "=", (Object)IntDataSource.SETTLEINT.getValue());
        return TmcDataServiceHelper.load((String)"fbd_surety_settleint", (String)SURETY_SETTLE_INT_PROP, (QFilter[])qFilter.toArray(), (String)"bizdate asc");
    }

    public static void preInterestBillDo(DynamicObject suretyBill) {
        QFilter qFilter = new QFilter("sourcebillid", "=", suretyBill.getPkValue());
        qFilter.and("operatetype", "=", (Object)PreIntOperateTypeEnum.PREINT.getValue());
        qFilter.and("datasource", "=", (Object)IntDataSource.PREINT.getValue());
        qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and("writeoffstatus", "!=", (Object)WriteOffStatusEnum.RED_WRITEOFF.getValue());
        DynamicObjectCollection preInterests = QueryServiceHelper.query((String)"fbd_surety_preint", (String)"id,loanbillno,operatetype,datasource,entrys,entrys.instenddate,prestenddate", (QFilter[])qFilter.toArray(), (String)"prestenddate,entrys.instenddate desc");
        Date preInstEndDate = null;
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)preInterests)) {
            preInstEndDate = ((DynamicObject)preInterests.get(0)).getDate("entrys.instenddate");
        }
        suretyBill.set("endpreinstdate", preInstEndDate);
    }

    private static void suretyBillWriteBack(Pair<BigDecimal, List<IntBillInfo>> interestCals, DynamicObject suretyBill) {
        String basis = suretyBill.getString("basis");
        int yearDay = TermHelper.getBasis_YearDay((int)1, (BasisEnum)BasisEnum.getEnum((String)basis));
        BigDecimal calculateRateAmount = (BigDecimal)interestCals.getKey();
        suretyBill.set("prefutureamt", (Object)calculateRateAmount);
        List intBills = (List)interestCals.getValue();
        DynamicObjectCollection interestEntryDC = suretyBill.getDynamicObjectCollection("revenue_entry");
        int seq = interestEntryDC.size() + 1;
        for (IntBillInfo intBill : intBills) {
            DynamicObject interestEntryDO = interestEntryDC.addNew();
            Date interestDate = intBill.getBizDate();
            BigDecimal interestAmount = intBill.getAmount();
            interestEntryDO.set("seq", (Object)seq++);
            interestEntryDO.set("revenueseq", (Object)interestEntryDC.size());
            interestEntryDO.set("revenuedate", (Object)interestDate);
            interestEntryDO.set("revenuecalamount", (Object)interestAmount);
            interestEntryDO.set("revenuetype", (Object)RevenueTypeEnum.REVENUE.getValue());
            interestEntryDO.set("revenuestate", (Object)RevenueStatEnum.NOT_DONE.getValue());
            List details = intBill.getDetails();
            DynamicObjectCollection interestSubEntryDC = interestEntryDO.getDynamicObjectCollection("revenue_subentry");
            interestSubEntryDC.clear();
            for (IntBillDetailInfo detail : details) {
                DynamicObject interestSubEntryDO = interestSubEntryDC.addNew();
                interestSubEntryDO.set("seq", (Object)detail.getSeq());
                interestSubEntryDO.set("startdate", (Object)detail.getBeginDate());
                interestSubEntryDO.set("enddate", (Object)detail.getEndDate());
                interestSubEntryDO.set("days", (Object)detail.getDays());
                interestSubEntryDO.set("finamount", (Object)detail.getPrinciple());
                interestSubEntryDO.set("eplanrevenue", (Object)detail.getRate());
                interestSubEntryDO.set("convertdays", (Object)yearDay);
                interestSubEntryDO.set("erevenueamount", (Object)detail.getAmount());
            }
        }
    }

    public static void writeBackLastPreIntDate(Set<Object> suretyBillIds) {
        DynamicObject[] suretyBills;
        for (DynamicObject suretyBill : suretyBills = TmcDataServiceHelper.load((Object[])suretyBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fbd_suretybill"))) {
            RevenuePlanCalHelper.preInterestBillDo(suretyBill);
        }
        SaveServiceHelper.update((DynamicObject[])suretyBills);
    }
}

