/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.common.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.field.ComboItem;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SubscribeHelper {
    public static List<ComboItem> getOperateItems(String number) {
        List operateList = EntityMetadataCache.getDataEntityOperate((String)number);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(operateList.size());
        for (Map operate : operateList) {
            ComboItem item = new ComboItem();
            item.setValue((String)operate.get("key"));
            String namestr = ((Map)operate.get("name")).get(Lang.get().toString()).toString();
            item.setCaption(new LocaleString(namestr));
            items.add(item);
        }
        return items;
    }

    public static Set<String> getSubscribeOps(String datasourceId, long billid) {
        HashSet<String> subScribeOps = new HashSet<String>();
        QFilter filter = new QFilter("datasource", "=", (Object)datasourceId).and("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue());
        if (EmptyUtil.isNoEmpty((Long)billid)) {
            filter.and("id", "!=", (Object)billid);
        }
        DynamicObjectCollection subscribes = QueryServiceHelper.query((String)"fbd_subscribetpl", (String)"subscribeop", (QFilter[])new QFilter[]{filter}, null);
        for (DynamicObject subscribe : subscribes) {
            if (EmptyUtil.isEmpty((String)subscribe.getString("subscribeop"))) continue;
            subScribeOps.addAll(Arrays.stream(subscribe.getString("subscribeop").split(",")).filter(EmptyUtil::isNoEmpty).collect(Collectors.toSet()));
        }
        return subScribeOps;
    }
}

