/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.oppservice.feedetail;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.FeeDetailSrcBillStatusEnum;
import kd.tmc.fbp.common.enums.FeeSourceEnum;
import kd.tmc.fbp.common.enums.OppUnitTypeEnum;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.helper.CodeRuleHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FeeBatchInputSaveService
extends AbstractTmcBizOppService {
    private List<DynamicObject> needSaveFeeBillLists = new ArrayList<DynamicObject>(10);

    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("autoaudit");
        sic.add("autosettle");
        sic.add("batchno");
        sic.add("entry");
        sic.add("isfrombizbill");
        sic.add("entry.org");
        sic.add("entry.paydate");
        sic.add("entry.feetype");
        sic.add("entry.currency");
        sic.add("entry.payamt");
        sic.add("entry.feeacctbank");
        sic.add("entry.oppunittype");
        sic.add("entry.producttype");
        sic.add("entry.srcbillno");
        sic.add("entry.issettle");
        sic.add("entry.rate");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject info : dataEntities) {
            this.saveEntryData2FeeBill(info);
        }
    }

    private void saveEntryData2FeeBill(DynamicObject info) {
        DynamicObjectCollection entrys = info.getDynamicObjectCollection("entry");
        String batchNo = info.getString("batchno");
        for (DynamicObject entry : entrys) {
            String srcBillNo = entry.getString("srcbillno");
            DynamicObject feeProductType = entry.getDynamicObject("producttype");
            ProductTypeEnum typeEnum = ProductTypeEnum.getEnumById((String)String.valueOf(feeProductType.getPkValue()));
            DynamicObject bizBillInfo = EmptyUtil.isNoEmpty((String)srcBillNo) ? TmcDataServiceHelper.loadSingle((String)typeEnum.getEntity(), (String)"id", (QFilter[])new QFilter("cfm_creditlimit".equals(TmcBusinessBaseHelper.getBillFormId((String)typeEnum.getEntity())) ? "number" : "billno", "=", (Object)srcBillNo).toArray()) : null;
            BigDecimal payAmt = entry.getBigDecimal("payamt");
            if (EmptyUtil.isEmpty((String)entry.getString("feenumber"))) {
                DynamicObject feeBillDo = BusinessDataServiceHelper.newDynamicObject((String)"cfm_feebill");
                feeBillDo.set("amountrate", (Object)entry.getBigDecimal("rate"));
                DynamicObject org = entry.getDynamicObject("org");
                feeBillDo.set("org", (Object)org);
                feeBillDo.set("createtime", (Object)DateUtils.getCurrentTime());
                feeBillDo.set("modifytime", (Object)DateUtils.getCurrentTime());
                long user = RequestContext.get().getCurrUserId();
                feeBillDo.set("creator", (Object)user);
                feeBillDo.set("modifier", (Object)user);
                boolean autoAudit = info.getBoolean("autoaudit");
                if (autoAudit) {
                    feeBillDo.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
                    feeBillDo.set("auditor", (Object)RequestContext.get().getCurrUserId());
                } else {
                    feeBillDo.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
                }
                feeBillDo.set("batchno", (Object)batchNo);
                feeBillDo.set("feetype", (Object)entry.getDynamicObject("feetype"));
                feeBillDo.set("paydate", (Object)entry.getDate("paydate"));
                feeBillDo.set("currency", (Object)entry.getDynamicObject("currency"));
                feeBillDo.set("payamt", (Object)entry.getBigDecimal("payamt"));
                String oppUnitType = entry.getString("oppunittype");
                feeBillDo.set("oppunittype", (Object)oppUnitType);
                DynamicObject feeAcctBank = entry.getDynamicObject("feeacctbank");
                feeBillDo.set("feeacctbank", (Object)feeAcctBank);
                if (EmptyUtil.isNoEmpty((DynamicObject)feeAcctBank) && OppUnitTypeEnum.FINORGINFO.getValue().equals(oppUnitType)) {
                    DynamicObject bank = feeAcctBank.getDynamicObject("bank");
                    feeBillDo.set("oppunit", EmptyUtil.isNoEmpty((DynamicObject)bank) ? bank.getPkValue() : null);
                    feeBillDo.set("oppunittext", EmptyUtil.isNoEmpty((DynamicObject)bank) ? bank.getString("name") : null);
                }
                feeBillDo.set("feesource", (Object)(info.getBoolean("isfrombizbill") ? FeeSourceEnum.BIZPATCH.getValue() : FeeSourceEnum.BATCHINPUT.getValue()));
                feeBillDo.set("sharetype", (Object)entry.getString("sharetype"));
                feeBillDo.set("issettle", (Object)entry.getBoolean("issettle"));
                String appSource = this.getAppSource(typeEnum.getFormId());
                feeBillDo.set("appsource", (Object)appSource);
                DynamicObjectCollection newEntrys = feeBillDo.getDynamicObjectCollection("entry");
                DynamicObject newFeeEntry = newEntrys.addNew();
                newFeeEntry.set("producttype", (Object)feeProductType);
                newFeeEntry.set("srcbillno", (Object)srcBillNo);
                newFeeEntry.set("excrate", (Object)entry.getString("excrate"));
                if (bizBillInfo != null && "lc".equals(appSource)) {
                    this.lcBizDeal(bizBillInfo, newFeeEntry);
                }
                newFeeEntry.set("srcbillid", bizBillInfo != null ? Long.valueOf(bizBillInfo.getLong("id")) : null);
                newFeeEntry.set("feeratio", (Object)100);
                newFeeEntry.set("feedetailamt", (Object)payAmt);
                String feeBillNum = CodeRuleHelper.generateNumber((String)"cfm_feebill", (DynamicObject)TmcDataServiceHelper.newDynamicObject((String)"cfm_feebill"), (String)String.valueOf(org.getPkValue()), (String)"");
                feeBillDo.set("billno", (Object)feeBillNum);
                this.needSaveFeeBillLists.add(feeBillDo);
                continue;
            }
            DynamicObject feeBill = TmcDataServiceHelper.loadSingle((Object)entry.getLong("feebillid"), (String)"cfm_feebill");
            DynamicObjectCollection feeBillEntrys = feeBill.getDynamicObjectCollection("entry");
            DynamicObject newRow = feeBillEntrys.addNew();
            newRow.set("producttype", (Object)feeProductType);
            newRow.set("srcbillno", (Object)srcBillNo);
            newRow.set("srcbillid", bizBillInfo != null ? Long.valueOf(bizBillInfo.getLong("id")) : null);
            BigDecimal feeBillPayAmt = feeBill.getBigDecimal("payamt");
            BigDecimal enPayAmt = feeBill.getBigDecimal("enpayamt");
            BigDecimal rowRatio = payAmt.divide(feeBillPayAmt, 6, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L));
            newRow.set("feeratio", (Object)rowRatio);
            newRow.set("feedetailamt", (Object)payAmt);
            newRow.set("srcstatus", (Object)FeeDetailSrcBillStatusEnum.AUDIT.getValue());
            newRow.set("excrate", (Object)entry.getBigDecimal("excrate"));
            String appSource = this.getAppSource(typeEnum.getFormId());
            if (bizBillInfo != null && "lc".equals(appSource)) {
                this.lcBizDeal(bizBillInfo, newRow);
            }
            feeBill.set("enpayamt", (Object)enPayAmt.subtract(payAmt));
            this.needSaveFeeBillLists.add(feeBill);
        }
        if (EmptyUtil.isNoEmpty(this.needSaveFeeBillLists)) {
            SaveServiceHelper.save((DynamicObject[])this.needSaveFeeBillLists.toArray(new DynamicObject[0]));
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        for (DynamicObject info : dataEntities) {
            OperationResult result;
            boolean autoSettle = info.getBoolean("autosettle");
            String batchNo = info.getString("batchno");
            List<DynamicObject> unSettleFeeDetails = this.needSaveFeeBillLists.stream().filter(o -> !o.getBoolean("issettle")).collect(Collectors.toList());
            if (!autoSettle || !EmptyUtil.isNoEmpty(unSettleFeeDetails) || null == (result = TmcOperateServiceHelper.execOperateWithoutThrow((String)"settle", (String)"cfm_feebill", (DynamicObject[])unSettleFeeDetails.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create())) || result.isSuccess()) continue;
            DeleteServiceHelper.delete((String)"cfm_feebill", (QFilter[])new QFilter("batchno", "=", (Object)batchNo).toArray());
            throw new TmcBizException(TmcErrorCode.COMMON, new Object[]{TmcOperateServiceHelper.decodeErrorMsg((OperationResult)result)});
        }
    }

    private String getAppSource(String formId) {
        return TmcBusinessBaseHelper.getAppSource((String)formId);
    }

    private void lcBizDeal(DynamicObject info, DynamicObject newFeeEntry) {
        String entityName = info.getDynamicObjectType().getName();
        if (ProductTypeEnum.LC_LETTER.getEntity().equals(entityName) || ProductTypeEnum.LC_RECEIPT.getEntity().equals(entityName)) {
            DynamicObject bizDetailInfo = TmcDataServiceHelper.loadSingle((String)entityName, (String)"id,creditno", (QFilter[])new QFilter("id", "=", info.getPkValue()).toArray());
            newFeeEntry.set("creditno", (Object)bizDetailInfo.getString("creditno"));
        } else if (ProductTypeEnum.LC_ARRIVAL.getEntity().equals(entityName) || ProductTypeEnum.LC_PRESENT.getEntity().equals(entityName)) {
            DynamicObject bizDetailInfo = TmcDataServiceHelper.loadSingle((String)entityName, (String)"id,lettercredit,arrivalno", (QFilter[])new QFilter("id", "=", info.getPkValue()).toArray());
            DynamicObject letterCredit = bizDetailInfo.getDynamicObject("lettercredit");
            if (EmptyUtil.isNoEmpty((DynamicObject)letterCredit)) {
                newFeeEntry.set("creditno", (Object)letterCredit.getString("number"));
            }
            newFeeEntry.set("arrisubno", (Object)bizDetailInfo.getString("arrivalno"));
        } else if (ProductTypeEnum.LC_FORFAIT.getEntity().equals(entityName)) {
            DynamicObject arrivalNo;
            DynamicObject bizDetailInfo = TmcDataServiceHelper.loadSingle((String)entityName, (String)"id,lettercredit,arrivalno", (QFilter[])new QFilter("id", "=", info.getPkValue()).toArray());
            DynamicObject letterCredit = bizDetailInfo.getDynamicObject("lettercredit");
            if (EmptyUtil.isNoEmpty((DynamicObject)letterCredit)) {
                newFeeEntry.set("creditno", (Object)letterCredit.getString("number"));
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)(arrivalNo = bizDetailInfo.getDynamicObject("arrivalno")))) {
                newFeeEntry.set("arrisubno", (Object)arrivalNo.getString("arrivalno"));
            }
        }
    }
}

