/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.oppservice.feedetail;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FeeDetailSaveService
extends AbstractTmcBizOppService {
    private static final Log LOGGER = LogFactory.getLog(FeeDetailSaveService.class);

    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("oppunit");
        sic.add("oppunittext");
        sic.add("billstatus");
        sic.add("billno");
        sic.add("payamt");
        sic.add("entry");
        sic.add("entry.feedetailamt");
        sic.add("entry.producttype");
        sic.add("entry.feeratio");
        sic.add("entry.srcbillno");
        sic.add("entry.srcbillid");
        sic.add("entry.creditno");
        sic.add("entry.arrisubno");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject info : dataEntities) {
            DynamicObject oppUnit = info.getDynamicObject("oppunit");
            if (!EmptyUtil.isEmpty((DynamicObject)oppUnit)) {
                info.set("oppunittext", (Object)oppUnit.getString("name"));
            }
            this.dealImportSaveOp(info);
        }
    }

    private void dealImportSaveOp(DynamicObject info) {
        Long srcBillId;
        ProductTypeEnum productTypeEnum;
        DynamicObject feeEntry;
        DynamicObject productType;
        DynamicObjectCollection entrys = info.getDynamicObjectCollection("entry");
        BigDecimal payAmt = info.getBigDecimal("payamt");
        Iterator iterator = entrys.iterator();
        while (iterator.hasNext() && !EmptyUtil.isEmpty((DynamicObject)(productType = (feeEntry = (DynamicObject)iterator.next()).getDynamicObject("producttype"))) && !EmptyUtil.isEmpty((Object)(productTypeEnum = ProductTypeEnum.getEnumByValue((String)productType.getString("number")))) && !EmptyUtil.isNoEmpty((Long)(srcBillId = Long.valueOf(feeEntry.getLong("srcbillid"))))) {
            DynamicObjectCollection bizBills;
            String bizBillEntity = productTypeEnum.getEntity();
            String srcBillNo = feeEntry.getString("srcbillno");
            String creditNo = feeEntry.getString("creditno");
            BigDecimal feeRatio = feeEntry.getBigDecimal("feeratio");
            BigDecimal feeDetailAmt = feeEntry.getBigDecimal("feedetailamt");
            if (EmptyUtil.isNoEmpty((BigDecimal)feeRatio) && EmptyUtil.isEmpty((BigDecimal)feeDetailAmt)) {
                BigDecimal detailAmt = payAmt.multiply(feeRatio.divide(BigDecimal.valueOf(100L), payAmt.scale(), RoundingMode.HALF_UP));
                feeEntry.set("feedetailamt", (Object)detailAmt);
            } else if (EmptyUtil.isEmpty((BigDecimal)feeRatio) && EmptyUtil.isNoEmpty((BigDecimal)feeDetailAmt)) {
                BigDecimal rowRatio = feeDetailAmt.divide(payAmt, payAmt.scale(), RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L));
                feeEntry.set("feeratio", (Object)rowRatio);
            }
            QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
            if (!EmptyUtil.isNoEmpty((String)srcBillNo) || !EmptyUtil.isEmpty((String)creditNo) || !bizBillEntity.startsWith("lc_")) continue;
            String fieldProp = "id,billno";
            qFilter.and(new QFilter("billno", "=", (Object)srcBillNo));
            if (ProductTypeEnum.LC_ARRIVAL.getEntity().equals(bizBillEntity) || ProductTypeEnum.LC_PRESENT.getEntity().equals(bizBillEntity)) {
                fieldProp = "id,billno,lettercredit.number,arrivalno";
            } else if (ProductTypeEnum.LC_FORFAIT.getEntity().equals(bizBillEntity)) {
                fieldProp = "id,billno,lettercredit.number,arrivalno.arrivalno";
            } else if (ProductTypeEnum.LC_LETTER.getEntity().equals(bizBillEntity)) {
                fieldProp = "id,billno,creditno";
            }
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)(bizBills = QueryServiceHelper.query((String)bizBillEntity, (String)fieldProp, (QFilter[])qFilter.toArray()))) || bizBills.size() != 1) continue;
            DynamicObject bizBill = (DynamicObject)bizBills.get(0);
            feeEntry.set("srcbillid", bizBill.getPkValue());
            if (ProductTypeEnum.LC_ARRIVAL.getEntity().equals(bizBillEntity) || ProductTypeEnum.LC_PRESENT.getEntity().equals(bizBillEntity)) {
                feeEntry.set("creditno", (Object)bizBill.getString("lettercredit.number"));
                feeEntry.set("arrisubno", (Object)bizBill.getString("arrivalno"));
                continue;
            }
            if (ProductTypeEnum.LC_FORFAIT.getEntity().equals(bizBillEntity)) {
                feeEntry.set("creditno", (Object)bizBill.getString("lettercredit.number"));
                feeEntry.set("arrisubno", (Object)bizBill.getString("arrivalno.arrivalno"));
                continue;
            }
            if (!ProductTypeEnum.LC_LETTER.getEntity().equals(bizBillEntity)) continue;
            feeEntry.set("creditno", (Object)bizBill.getString("creditno"));
        }
    }
}

