/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.oppservice.feedetail;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FeeDetailUnSettleOpService
extends AbstractTmcBizOppService {
    private static final Log LOGGER = LogFactory.getLog(FeeDetailUnSettleOpService.class);

    public List<String> getSelector() {
        List lst = super.getSelector();
        lst.add("payamt");
        lst.add("issettle");
        lst.add("billstatus");
        lst.add("paybill");
        return lst;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        Long[] ids = (Long[])Arrays.stream(dataEntities).map(o -> o.getLong("id")).toArray(Long[]::new);
        Map targetBills = BFTrackerServiceHelper.findTargetBills((String)dataEntities[0].getDataEntityType().getName(), (Long[])ids);
        HashSet downBillType = new HashSet(targetBills.keySet());
        if (downBillType.contains("cas_paybill")) {
            this.deletePushRecOrPaybill("cas_paybill", targetBills);
        }
        if (downBillType.contains("cas_recbill")) {
            this.deletePushRecOrPaybill("cas_recbill", targetBills);
        }
    }

    private void deletePushRecOrPaybill(String downBillType, Map<String, HashSet<Long>> targetBills) {
        Object[] downbillIds = targetBills.entrySet().stream().filter(o -> downBillType.equals(o.getKey())).map(Map.Entry::getValue).flatMap(Collection::stream).toArray();
        QFilter filter = new QFilter("id", "in", (Object)downbillIds).and("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue());
        DynamicObjectCollection downbills = QueryServiceHelper.query((String)downBillType, (String)"id,billstatus", (QFilter[])new QFilter[]{filter});
        Set deleteIds = downbills.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet());
        if (EmptyUtil.isNoEmpty(deleteIds)) {
            TmcOperateServiceHelper.execOperate((String)"delete", (String)downBillType, (Object[])deleteIds.toArray(), (OperateOption)OperateOption.create(), (boolean)true);
        }
    }
}

