/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.feedetail;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.ShareTypeEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.StringUtils;

public class FeeBatchInputSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("entry");
        sic.add("batchno");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            DynamicObjectCollection feeDetails;
            DynamicObject info = dataEntity.getDataEntity();
            String batchNo = info.getString("batchno");
            if (TmcDataServiceHelper.exists((String)"cfm_feebill", (QFilter[])new QFilter("batchno", "=", (Object)batchNo).toArray())) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u6279\u6570\u636e\u5df2\u7ecf\u751f\u6210\u8d39\u7528\u660e\u7ec6\u5355\u636e,\u4e0d\u80fd\u91cd\u590d\u751f\u6210\u3002", (String)"FeeBatchInputSaveValidator_01", (String)"tmc-fbd-business", (Object[])new Object[0]));
            }
            DynamicObjectCollection feeDetailEntrys = info.getDynamicObjectCollection("entry");
            Set feeBillIds = feeDetailEntrys.stream().map(s -> s.getLong("feebillid")).collect(Collectors.toSet());
            DynamicObjectCollection feeBills = QueryServiceHelper.query((String)"cfm_feebill", (String)"id,enpayamt", (QFilter[])new QFilter[]{new QFilter("id", "in", feeBillIds)});
            Map<Long, BigDecimal> enpayamtMap = feeBills.stream().collect(Collectors.toMap(s -> s.getLong("id"), s -> s.getBigDecimal("enpayamt")));
            HashSet<String> srcBillNos = new HashSet<String>();
            String feeShareEntity = "cfm_loanfeeshare";
            for (int i = 0; i < feeDetailEntrys.size(); ++i) {
                DynamicObject productType;
                DynamicObject feeProductType;
                ProductTypeEnum typeEnum;
                DynamicObject feeEntry = (DynamicObject)feeDetailEntrys.get(i);
                BigDecimal excrate = feeEntry.getBigDecimal("excrate");
                if (EmptyUtil.isEmpty((BigDecimal)excrate)) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8d39\u7528\u660e\u7ec6\u7684\u7b2c\u3010%s\u3011\u884c\u6298\u503a\u52a1\u5e01\u79cd\u6c47\u7387\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FeeBatchInputSaveValidator_07", (String)"tmc-fbd-business", (Object[])new Object[0]), i + 1));
                }
                if (EmptyUtil.isEmpty((Object)feeEntry.get("srcbillno")) && !"cdm".equals(TmcBusinessBaseHelper.getAppSource((String)(typeEnum = ProductTypeEnum.getEnumById((String)String.valueOf((feeProductType = feeEntry.getDynamicObject("producttype")).getPkValue()))).getFormId()))) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8d39\u7528\u660e\u7ec6\u7684\u7b2c\u3010%s\u3011\u884c\u6765\u6e90\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FeeBatchInputSaveValidator_02", (String)"tmc-fbd-business", (Object[])new Object[0]), i + 1));
                }
                long feeBillId = feeEntry.getLong("feebillid");
                if (EmptyUtil.isNoEmpty(enpayamtMap) && enpayamtMap.containsKey(feeBillId)) {
                    BigDecimal payamt = feeEntry.getBigDecimal("payamt");
                    BigDecimal enpayamt = enpayamtMap.get(feeBillId);
                    if (payamt.abs().compareTo(enpayamt.abs()) > 0) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5f55\u5165\u7684\u8d39\u7528\u91d1\u989d\u8d85\u8fc7\u5173\u8054\u7684\u8d39\u7528\u660e\u7ec6[%s]\u7684\u5269\u4f59\u8d39\u7528\u91d1\u989d\u3002", (String)"BatchFeeInputPlugin_07", (String)"tmc-fbd-formplugin", (Object[])new Object[0]), feeEntry.getString("feenumber")));
                    }
                }
                String shareType = feeEntry.getString("sharetype");
                if (ShareTypeEnum.NOTSHARE.getValue().equals(shareType)) continue;
                String srcBillNo = feeEntry.getString("srcbillno");
                if (EmptyUtil.isNoEmpty((String)srcBillNo)) {
                    srcBillNos.add(srcBillNo);
                }
                if (EmptyUtil.isNoEmpty((DynamicObject)(productType = feeEntry.getDynamicObject("producttype"))) && ProductTypeEnum.LOANBILL_BOND.getId().equals(productType.getString("id"))) {
                    feeShareEntity = "bdim_costshare";
                }
                ProductTypeEnum typeEnum2 = ProductTypeEnum.getEnumById((String)String.valueOf(productType.getPkValue()));
                String appSource = TmcBusinessBaseHelper.getAppSource((String)typeEnum2.getFormId());
                if (TmcAppEnum.CFM.getValue().equals(appSource) && !ProductTypeEnum.LOANBILL_B_L.getId().equals(productType.getString("id"))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u644a\u9500\u65b9\u5f0f\u4e3a\u5b9e\u9645\u5229\u7387\u6cd5\u6216\u76f4\u7ebf\u6cd5\u65f6\uff0c\u4ea7\u54c1\u7c7b\u578b\u53ea\u80fd\u9009\u62e9\u94f6\u884c\u501f\u6b3e\u501f\u636e\u3002", (String)"FeeBatchInputSaveValidator_05", (String)"tmc-fbd-business", (Object[])new Object[0]));
                    continue;
                }
                if (!"bdim".equals(appSource) || ProductTypeEnum.LOANBILL_BOND.getId().equals(productType.getString("id"))) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u644a\u9500\u65b9\u5f0f\u4e3a\u5b9e\u9645\u5229\u7387\u6cd5\u6216\u76f4\u7ebf\u6cd5\u65f6\uff0c\u4ea7\u54c1\u7c7b\u578b\u53ea\u80fd\u9009\u62e9\u503a\u5238\u53d1\u884c\u3002", (String)"FeeBatchInputSaveValidator_06", (String)"tmc-fbd-business", (Object[])new Object[0]));
            }
            if (srcBillNos.size() <= 0) continue;
            DynamicObjectCollection bondBills = QueryServiceHelper.query((String)feeShareEntity, (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("billno", "in", srcBillNos), new QFilter("billstatus", "!=", (Object)BillStatusEnum.SAVE.getValue())});
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)bondBills)) {
                String validataMsg = ResManager.loadKDString((String)"\u94f6\u884c\u63d0\u6b3e\u5904\u7406%s\u4e0b\u6e38\u7684\u94f6\u884c\u63d0\u6b3e\u8d39\u7528\u644a\u9500\u5355\u975e\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u80fd\u518d\u65b0\u589e\u644a\u9500\u7684\u8d39\u7528\u3002", (String)"FeeBatchInputSaveValidator_03", (String)"tmc-fbd-business", (Object[])new Object[0]);
                if ("bdim_costshare".equals(feeShareEntity)) {
                    validataMsg = ResManager.loadKDString((String)"\u503a\u5238\u53d1\u884c%s\u4e0b\u6e38\u7684\u6210\u672c\u644a\u9500\u5355\u975e\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u80fd\u518d\u65b0\u589e\u644a\u9500\u7684\u8d39\u7528\u3002", (String)"FeeBatchInputSaveValidator_04", (String)"tmc-fbd-business", (Object[])new Object[0]);
                }
                Set billnos = bondBills.stream().map(o -> o.getString("billno")).collect(Collectors.toSet());
                this.addMessage(dataEntity, String.format(validataMsg, StringUtils.setToString(billnos)));
            }
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)(feeDetails = QueryServiceHelper.query((String)"cfm_feebill", (String)"sharetype,entry.srcbillno", (QFilter[])new QFilter[]{new QFilter("entry.srcbillno", "in", srcBillNos), new QFilter("sharetype", "not in", (Object)new Object[]{ShareTypeEnum.NOTSHARE.getValue()})})))) continue;
            HashMap shareTypeOfBill = new HashMap(16);
            feeDetails.forEach(s -> shareTypeOfBill.put(s.getString("entry.srcbillno"), s.getString("sharetype")));
            List errorBillno = feeDetailEntrys.stream().filter(r -> !r.getString("sharetype").equals(shareTypeOfBill.get(r.getString("srcbillno")))).map(r -> r.getString("srcbillno")).collect(Collectors.toList());
            if (!EmptyUtil.isNoEmpty(errorBillno)) continue;
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u8d39\u7528\u7684\u644a\u9500\u65b9\u5f0f\u4e0e\u6765\u6e90\u5355\u636e\u53f7%s\u5df2\u6709\u8d39\u7528\u7684\u644a\u9500\u65b9\u5f0f\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FeeDetailSubmitValidator_3", (String)"tmc-fbd-business", (Object[])new Object[]{errorBillno.get(0)}));
        }
    }
}

