/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.feedetail;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.StringUtils;

public class FeeDetailAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("entry");
        sic.add("entry.producttype");
        sic.add("entry.srcbillno");
        sic.add("entry.srcbillid");
        sic.add("sharetype");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            DynamicObject info = dataEntity.getDataEntity();
            DynamicObjectCollection entrys = info.getDynamicObjectCollection("entry");
            if (!"1".equals(info.getString("sharetype"))) continue;
            this.checkFeeCostShare(dataEntity, entrys);
        }
    }

    private void checkFeeCostShare(ExtendedDataEntity dataEntity, DynamicObjectCollection entrys) {
        HashSet<Long> bondIds = new HashSet<Long>();
        String feeShareEntryName = "bdim_costshare";
        for (DynamicObject entry : entrys) {
            String formId;
            DynamicObject productType = entry.getDynamicObject("producttype");
            if (EmptyUtil.isEmpty((DynamicObject)productType) || !"cfm_loanbill_bond".equals(formId = ProductTypeEnum.getEnumByValue((String)productType.getString("number")).getFormId()) && !"cfm_loanbill_b_l".equals(formId)) continue;
            if ("cfm_loanbill_b_l".equals(formId)) {
                feeShareEntryName = "cfm_loanfeeshare";
            }
            bondIds.add(entry.getLong("srcbillid"));
        }
        if (bondIds.size() > 0) {
            Object[] bondBills;
            String validataMsg = ResManager.loadKDString((String)"\u94f6\u884c\u63d0\u6b3e\u5904\u7406%s\u4e0b\u6e38\u7684\u94f6\u884c\u63d0\u6b3e\u8d39\u7528\u644a\u9500\u5355\u975e\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u80fd\u518d\u65b0\u589e\u644a\u9500\u7684\u8d39\u7528\u3002", (String)"FeeDetailSaveValidator_10", (String)"tmc-fbd-business", (Object[])new Object[0]);
            if ("bdim_costshare".equals(feeShareEntryName)) {
                validataMsg = ResManager.loadKDString((String)"\u503a\u5238\u53d1\u884c%s\u4e0b\u6e38\u7684\u503a\u5238\u6210\u672c\u644a\u9500\u5355\u975e\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u80fd\u518d\u65b0\u589e\u644a\u9500\u7684\u8d39\u7528\u3002", (String)"FeeDetailSaveValidator_11", (String)"tmc-fbd-business", (Object[])new Object[0]);
            }
            if (EmptyUtil.isNoEmpty((Object[])(bondBills = TmcDataServiceHelper.load((String)feeShareEntryName, (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", bondIds), new QFilter("billstatus", "in", (Object)new Object[]{BillStatusEnum.SUBMIT.getValue(), BillStatusEnum.AUDIT.getValue()})})))) {
                Set billnos = Arrays.stream(bondBills).map(o -> o.getString("billno")).collect(Collectors.toSet());
                this.addMessage(dataEntity, String.format(validataMsg, StringUtils.setToString(billnos)));
            }
        }
    }
}

