/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.feedetail;

import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.tmc.fbd.common.enums.FbdEntityEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FeeDetailUnSettleOpValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject info = dataEntity.getDataEntity();
            if (!info.getBoolean("issettle")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5df2\u7ed3\u7b97\u7684\u8d39\u7528\u660e\u7ec6\u8fdb\u884c\u53cd\u7ed3\u7b97\u64cd\u4f5c\u3002", (String)"FeeDetailUnSettleOpValidator_0", (String)"tmc-fbd-business", (Object[])new Object[0]));
                return;
            }
            this.volidPushTargetBillStatus(dataEntity);
        }
    }

    private void volidPushTargetBillStatus(ExtendedDataEntity dataEntity) {
        DynamicObject info = dataEntity.getDataEntity();
        Map targetBills = BFTrackerServiceHelper.findTargetBills((String)info.getDataEntityType().getName(), (Long[])new Long[]{info.getLong("id")});
        if (EmptyUtil.isEmpty((Object)targetBills) || targetBills.size() == 0) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u5355\u636e\u6ca1\u6709\u4e0b\u6e38\u7ed3\u7b97\u5355\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"FeeDetailUnSettleOpValidator_2", (String)"tmc-fbd-business", (Object[])new Object[0]));
        } else {
            for (Map.Entry<String, HashSet<Long>> entry : targetBills.entrySet()) {
                String entityName = (String)entry.getKey();
                if (!FbdEntityEnum.CAS_PAYBILL.getValue().equals(entityName) && !FbdEntityEnum.CAS_RECBILL.getValue().equals(entityName)) continue;
                DynamicObjectCollection tagBills = this.queryBillsOrderByCreateTime(entry, entityName);
                if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)tagBills)) break;
                DynamicObject targBill = (DynamicObject)tagBills.get(0);
                if (BillStatusEnum.SAVE.getValue().equals(targBill.getString("billstatus"))) break;
                LocaleString displayName = targBill.getDynamicObjectType().getDisplayName();
                String displayNameStr = EmptyUtil.isEmpty((Object)displayName) ? "" : displayName.toString();
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u4e0b\u6e38%1$s\u5355\u636e\u7f16\u53f7\u4e3a:%2$s\u4e0d\u662f\u6682\u5b58\u72b6\u6001,\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"FeeDetailUnSettleOpValidator_1", (String)"tmc-fbd-business", (Object[])new Object[0]), displayNameStr, targBill.getString("billno")));
                break;
            }
        }
    }

    private DynamicObjectCollection queryBillsOrderByCreateTime(Map.Entry<String, HashSet<Long>> tagbillsListMap, String entityName) {
        HashSet<Long> pushTargIdSet = tagbillsListMap.getValue();
        QFilter filter = new QFilter("id", "in", pushTargIdSet);
        return QueryServiceHelper.query((String)entityName, (String)"id,billstatus,billno,createtime", (QFilter[])new QFilter[]{filter}, (String)"createtime desc");
    }
}

