/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.async;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Future;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.tmc.fbd.business.async.AsyncTaskSupport;
import kd.tmc.fbp.common.constant.RpcResult;

public class AsyncLongtimeTaskScheduler
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(AsyncLongtimeTaskScheduler.class);
    private static long defaultTimeOutInSec = 300L;
    private static final String PARAM_TIME_OUT = "pTimeoutInSec";

    public void execute(RequestContext rc, Map<String, Object> arg) throws KDException {
        String argTimeout;
        logger.info("execute begin");
        AsyncTaskSupport asyncTaskSupport = new AsyncTaskSupport();
        QFilter qFilter = new QFilter("longtimetask", "=", (Object)Boolean.TRUE);
        Optional<List<DynamicObject>> optional = asyncTaskSupport.loadTasks(qFilter);
        if (!optional.isPresent()) {
            return;
        }
        Map<DynamicObject, Future<RpcResult>> futureMap = asyncTaskSupport.executeLongtimeTask(optional.get());
        long timeoutInSec = defaultTimeOutInSec;
        if (arg != null && (argTimeout = (String)arg.get(PARAM_TIME_OUT)) != null) {
            timeoutInSec = Long.parseLong(argTimeout);
        }
        asyncTaskSupport.wait(futureMap, timeoutInSec);
        logger.info("execute end");
    }
}

