/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.async;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class AsyncTaskCleanupScheduler
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(AsyncTaskCleanupScheduler.class);
    private static final long DEFAULT_PERIOD_RESET_STATUS = 59L;
    private static final long DEFAULT_PERIOD_REMOVE = 60L;
    private static final String PARAM_PERIOD_TIME_FOR_RESET = "pPeriodTimeForResetInSec";
    private static final String PARAM_PERIOD_TIME_FOR_REMOVE = "pPeriodTimeForRemoveInDay";

    public void execute(RequestContext rc, Map<String, Object> arg) throws KDException {
        this.resetStatus(rc, arg);
        this.removeOldTasks(rc, arg);
    }

    private void resetStatus(RequestContext rc, Map<String, Object> arg) {
        int limit;
        Instant inst;
        QFilter timeFilter;
        QFilter qc;
        QFilter[] qFilters;
        String selectFields;
        DynamicObject[] dynamicObjects;
        String pTimePeriod;
        QFilter statusFilter = new QFilter("status", "=", (Object)"2");
        long timePeriod = 59L;
        if (arg != null && (pTimePeriod = (String)arg.get(PARAM_PERIOD_TIME_FOR_RESET)) != null) {
            timePeriod = Long.parseLong(pTimePeriod);
        }
        if ((dynamicObjects = BusinessDataServiceHelper.load((String)"fbd_asyncinvocationtask", (String)(selectFields = "id, status, laststarttime"), (QFilter[])(qFilters = new QFilter[]{qc = statusFilter.and(timeFilter = new QFilter("laststarttime", "<", (Object)Date.from(inst = Instant.now().minus(timePeriod, ChronoUnit.MINUTES))))}), null, (int)(limit = 500))) == null) {
            return;
        }
        for (DynamicObject task : dynamicObjects) {
            task.set("status", (Object)"1");
        }
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            try (TXHandle h1 = TX.requiresNew();){
                try {
                    SaveServiceHelper.save((DynamicObject[])dynamicObjects);
                }
                catch (Exception e) {
                    h1.markRollback();
                    logger.error((Throwable)e);
                }
            }
        }
    }

    private void removeOldTasks(RequestContext rc, Map<String, Object> arg) {
        String pTimePeriod;
        QFilter statusFilter = new QFilter("status", "in", (Object)new String[]{"3", "4"});
        long timePeriod = 60L;
        if (arg != null && (pTimePeriod = (String)arg.get(PARAM_PERIOD_TIME_FOR_REMOVE)) != null) {
            timePeriod = Long.parseLong(pTimePeriod);
        }
        Instant inst = Instant.now().minus(timePeriod, ChronoUnit.DAYS);
        QFilter timeFilter = new QFilter("lastendtime", "<", (Object)Date.from(inst));
        QFilter qc = statusFilter.and(timeFilter);
        QFilter[] qFilters = new QFilter[]{qc};
        try (TXHandle h1 = TX.requiresNew();){
            try {
                DeleteServiceHelper.delete((String)"fbd_asyncinvocationtask", (QFilter[])qFilters);
            }
            catch (Exception e) {
                h1.markRollback();
                logger.error((Throwable)e);
            }
        }
    }
}

