/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.async;

import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbd.business.async.TaskHandler;
import kd.tmc.fbp.common.constant.RpcResult;

public class AsyncTaskSupport {
    private static final Log logger = LogFactory.getLog(AsyncTaskSupport.class);

    private boolean needSkipped(DynamicObject task) {
        Instant now = Instant.now();
        Date nextTriggerTime = task.getDate("nexttriggertime");
        return nextTriggerTime != null && nextTriggerTime.toInstant().isAfter(now);
    }

    public Map<DynamicObject, Future<RpcResult>> executeShorttimeTask(List<DynamicObject> tasks) {
        int taskSize = tasks == null ? 0 : tasks.size();
        HashMap<DynamicObject, Future<RpcResult>> futureMap = new HashMap<DynamicObject, Future<RpcResult>>(taskSize);
        if (tasks == null) {
            return futureMap;
        }
        for (DynamicObject task : tasks) {
            if (this.needSkipped(task)) continue;
            Future f = ThreadService.submit((Callable)new TaskHandler(task, true), (TaskType)TaskType.FBD_SHOR_TIME_TASK);
            futureMap.put(task, f);
        }
        return futureMap;
    }

    public Map<DynamicObject, Future<RpcResult>> executeLongtimeTask(List<DynamicObject> tasks) {
        int taskSize = tasks == null ? 0 : tasks.size();
        HashMap<DynamicObject, Future<RpcResult>> futureMap = new HashMap<DynamicObject, Future<RpcResult>>(taskSize);
        if (tasks == null) {
            return futureMap;
        }
        for (DynamicObject task : tasks) {
            if (this.needSkipped(task)) continue;
            Future f = ThreadService.submit((Callable)new TaskHandler(task, true), (TaskType)TaskType.FBD_LONG_TIME_TASK);
            futureMap.put(task, f);
        }
        return futureMap;
    }

    public void wait(Map<DynamicObject, Future<RpcResult>> futureMap, long defaultTimeOutInSec) {
        if (futureMap == null) {
            return;
        }
        for (Map.Entry<DynamicObject, Future<RpcResult>> taskEntry : futureMap.entrySet()) {
            DynamicObject task = taskEntry.getKey();
            long taskTimeOutInSec = task.getLong("timeout");
            if (taskTimeOutInSec <= 0L) {
                taskTimeOutInSec = defaultTimeOutInSec;
            }
            Future<RpcResult> f = taskEntry.getValue();
            try {
                f.get(taskTimeOutInSec, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                logger.error("Exception happened:", (Throwable)e);
                if (f.isDone()) continue;
                f.cancel(true);
            }
        }
    }

    protected Optional<List<DynamicObject>> loadTasks(QFilter extraFilter) {
        int top;
        QFilter[] qFilters;
        DynamicObject[] dynamicObjects;
        String selectFields = "id,cloudid, appid, servicename,method, retrycount, maxretrycount, retryratethreshhold, status, longtimetask, laststarttime, lastendtime, timeout, parameterentry.id,parameterentry.seq, parameterentry.pvalue, nexttriggertime, resultmessage, resultmessage_tag, createtime";
        QFilter qC = new QFilter("status", "in", (Object)new String[]{"1", "4"});
        qC.and(QFilter.of((String)"retrycount < maxretrycount", (Object[])new Object[0]));
        if (extraFilter != null) {
            qC.and(extraFilter);
        }
        if ((dynamicObjects = BusinessDataServiceHelper.load((String)"fbd_asyncinvocationtask", (String)selectFields, (QFilter[])(qFilters = new QFilter[]{qC}), null, (int)(top = 1000))) == null || dynamicObjects.length == 0) {
            return Optional.empty();
        }
        return Optional.of(Arrays.asList(dynamicObjects));
    }

    public RpcResult executeSync(DynamicObject task, boolean markAsExecuting) {
        return new TaskHandler(task, markAsExecuting).handle();
    }
}

