/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.async;

import com.alibaba.fastjson.JSON;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.tmc.fbp.common.constant.RpcResult;
import kd.tmc.fbp.common.constant.RpcResultStatusCode;

public class TaskHandler
implements Callable<RpcResult> {
    private static final Log logger = LogFactory.getLog(TaskHandler.class);
    private static int INTERVAL_IN_SEC = 3600;
    private DynamicObject task;
    private Date startTime;
    private Date completeTime;
    private boolean enableMarkAsExecuting = false;

    public TaskHandler(DynamicObject t) {
        this(t, false);
    }

    public TaskHandler(DynamicObject t, boolean enableMarkAsExecuting) {
        this.task = t;
        this.enableMarkAsExecuting = enableMarkAsExecuting;
    }

    @Override
    public RpcResult call() throws Exception {
        return this.handle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RpcResult handle() {
        this.startTime = new Date();
        if (this.enableMarkAsExecuting) {
            this.markAsExecuting();
        }
        RpcResult result = new RpcResult();
        try {
            Object[] objectArray;
            String cloudId = this.task.getString("cloudid");
            String appId = this.task.getString("appid");
            String service = this.task.getString("servicename");
            String method = this.task.getString("method");
            DynamicObjectCollection paramEntry = this.task.getDynamicObjectCollection("parameterentry");
            ArrayList params = new ArrayList();
            paramEntry.forEach(p -> params.add(p.getString("pvalue")));
            if (params.size() == 0) {
                objectArray = null;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = params;
            }
            Object[] oParams = objectArray;
            try (TXHandle h1 = TX.requiresNew((String)"TaskHandler.invokeBizService");){
                try {
                    String resultStr = (String)DispatchServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)service, (String)method, (Object[])oParams);
                    result = (RpcResult)JSON.parseObject((String)resultStr, RpcResult.class);
                }
                catch (Exception e) {
                    h1.markRollback();
                    throw e;
                }
            }
        }
        catch (Exception e) {
            result.setStatusCode(RpcResultStatusCode.ERROR);
            String exception = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            result.setMessage(exception);
            if (exception.indexOf(ResManager.loadKDString((String)"\u672a\u53d1\u73b0\u7c7b", (String)"TaskHandler_0", (String)"tmc-fbp-business", (Object[])new Object[0])) > 0 || exception.indexOf(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u3002", (String)"TaskHandler_1", (String)"tmc-fbp-business", (Object[])new Object[0])) > 0 || exception.indexOf("not find") > 0) {
                logger.info(exception);
            } else {
                logger.error((Throwable)e);
            }
        }
        finally {
            this.handleResult(result);
        }
        return result;
    }

    private void handleResult(RpcResult rs) {
        this.completeTime = new Date();
        if (rs.isSuccess()) {
            this.task.set("status", (Object)"3");
            this.task.set("nexttriggertime", null);
        } else {
            this.task.set("status", (Object)"4");
            this.applyRateLimitStrategy(this.task);
        }
        this.task.set("laststarttime", (Object)this.startTime);
        this.task.set("lastendtime", (Object)this.completeTime);
        StringBuilder resultMsg = new StringBuilder();
        resultMsg.append("traceid:").append(RequestContext.get().getTraceId()).append(",").append(rs.getMessage());
        this.task.set("resultmessage", (Object)(rs.getMessage() == null ? " " : resultMsg.substring(0, Math.min(250, resultMsg.length()))));
        this.task.set("resultmessage_tag", (Object)resultMsg.toString());
        this.task.set("retrycount", (Object)(this.task.getInt("retrycount") + 1));
        try (TXHandle h1 = TX.requiresNew((String)"TaskHandler.handleResult");){
            try {
                SaveServiceHelper.update((DynamicObject)this.task);
            }
            catch (Exception e) {
                h1.markRollback();
                logger.error((Throwable)e);
            }
        }
    }

    private boolean markAsExecuting() {
        this.task.set("laststarttime", (Object)this.startTime);
        this.task.set("status", (Object)"2");
        try (TXHandle h1 = TX.requiresNew((String)"TaskHandler.markAsExecuting");){
            try {
                SaveServiceHelper.update((DynamicObject)this.task);
            }
            catch (Exception e) {
                h1.markRollback();
                logger.error((Throwable)e);
            }
        }
        return true;
    }

    private void applyRateLimitStrategy(DynamicObject task) {
        int retryCount = task.getInt("retrycount") + 1;
        int retryRateThreshhold = task.getInt("retryratethreshhold");
        if (retryRateThreshhold > 0 && retryCount >= retryRateThreshhold) {
            long intervalInSEC = INTERVAL_IN_SEC * (retryCount - retryRateThreshhold);
            Instant nextTriggerTime = this.completeTime.toInstant().plusSeconds(intervalInSEC);
            Instant nextDayTime = this.completeTime.toInstant().plus(1L, ChronoUnit.DAYS);
            if (nextDayTime.isBefore(nextTriggerTime)) {
                nextTriggerTime = nextDayTime;
            }
            task.set("nexttriggertime", (Object)Date.from(nextTriggerTime));
        }
    }
}

