/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.oppservice.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.common.constant.RpcResult;

public class CommonUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(CommonUpgradeService.class);
    private String sourceColumn;
    private String sourceColumnType;
    private String targetColumn;
    private String targetColumnType;
    private String tableName;
    private String dbRoute;

    public String upgrade(List<String> listParams) {
        RpcResult result = new RpcResult();
        if (CollectionUtils.isEmpty(listParams)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CommonUpgradeService_0", (String)"tmc-fbp-business", (Object[])new Object[0]));
        }
        String paramStr = listParams.get(0);
        JSONObject jsonObject = JSON.parseObject((String)paramStr);
        this.checkParam(jsonObject);
        this.sourceColumn = (String)jsonObject.get((Object)"sourceColumn");
        this.sourceColumnType = (String)jsonObject.get((Object)"sourceColumnType");
        this.targetColumn = (String)jsonObject.get((Object)"targetColumn");
        this.targetColumnType = (String)jsonObject.get((Object)"targetColumnType");
        this.tableName = (String)jsonObject.get((Object)"tableName");
        this.dbRoute = (String)jsonObject.get((Object)"dbRoute");
        String selectColumn = "SELECT FID, " + this.sourceColumn + "," + this.targetColumn + " FROM " + this.tableName;
        DataSet selectSet = DB.queryDataSet((String)"synQuery", (DBRoute)new DBRoute(this.dbRoute), (String)selectColumn);
        if (selectSet == null || selectSet.isEmpty()) {
            LOGGER.info("{} {}\u672a\u627e\u5230\u6570\u636e\u3002", (Object)selectColumn, (Object)this.tableName);
            return JSON.toJSONString((Object)result);
        }
        for (Row row : selectSet) {
            if ("string".equals(this.sourceColumnType) && "number".equals(this.targetColumnType)) {
                this.upgradeStringToNumber(row);
                continue;
            }
            this.upgradeNumberToString(row);
        }
        return JSON.toJSONString((Object)result);
    }

    private void upgradeNumberToString(Row row) {
        boolean isInteger;
        Long id = (Long)row.get("FID");
        Object sourceColumnValue = row.get(this.sourceColumn);
        String targetColumnValue = (String)row.get(this.targetColumn);
        boolean isLong = sourceColumnValue instanceof Long && (Long)sourceColumnValue != 0L;
        boolean bl = isInteger = sourceColumnValue instanceof Integer && (Integer)sourceColumnValue != 0;
        if ((isLong || isInteger) && StringUtils.isBlank((CharSequence)targetColumnValue)) {
            ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
            String sBuilder = "update " + this.tableName + " set " + this.targetColumn + " = ? where fid = ?";
            params.add(new SqlParameter(":" + this.targetColumn, 12, (Object)String.valueOf(sourceColumnValue)));
            params.add(new SqlParameter(":fid", -5, (Object)id));
            DB.execute((DBRoute)new DBRoute(this.dbRoute), (String)sBuilder, (Object[])params.toArray(new SqlParameter[0]));
        }
    }

    private void upgradeStringToNumber(Row row) {
        Long id = (Long)row.get("FID");
        String sourceColumnValue = (String)row.get(this.sourceColumn);
        Long targetColumnValue = (Long)row.get(this.targetColumn);
        if (!StringUtils.isBlank((CharSequence)sourceColumnValue) && targetColumnValue == 0L) {
            ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
            String sBuilder = "update " + this.tableName + " set " + this.targetColumn + " = ? where fid = ?";
            params.add(new SqlParameter(":" + this.targetColumn, -5, (Object)Long.valueOf(sourceColumnValue)));
            params.add(new SqlParameter(":fid", -5, (Object)id));
            DB.execute((DBRoute)new DBRoute(this.dbRoute), (String)sBuilder, (Object[])params.toArray(new SqlParameter[0]));
        }
    }

    private void checkParam(JSONObject jsonObject) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : jsonObject.entrySet()) {
            if (!StringUtils.isEmpty((CharSequence)((String)entry.getValue()))) continue;
            sb.append(ResManager.loadKDString((String)"\u8bf7\u4f20\u53c2\u6570\uff1a", (String)"CommonUpgradeService_1", (String)"tmc-fbp-business", (Object[])new Object[0])).append((String)entry.getKey());
        }
        if (sb.length() > 0) {
            LOGGER.error("\u8bf7\u4f20\u53c2\u6570\uff1a{}\u3002", (Object)sb.toString());
            throw new KDBizException(sb.toString());
        }
    }
}

