/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.oppservice.foreignmarketrate;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;

public class ForeignMarketRateSaveService
extends AbstractTmcBizOppService {
    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject foreignMarketRate : dataEntities) {
            this.getMiddlePriceAndName(foreignMarketRate);
        }
    }

    public void getMiddlePriceAndName(DynamicObject foreignMarketRate) {
        BigDecimal buyingPrice = foreignMarketRate.getBigDecimal("buyingprice");
        BigDecimal sellingPrice = foreignMarketRate.getBigDecimal("sellingprice");
        String taCurrency = String.valueOf(foreignMarketRate.get("targetcurrency.name"));
        String orCurrency = String.valueOf(foreignMarketRate.get("originalcurrency.name"));
        if (BigDecimal.ZERO.compareTo(buyingPrice) != 0 && BigDecimal.ZERO.compareTo(sellingPrice) != 0) {
            foreignMarketRate.set("middleprice", (Object)buyingPrice.add(sellingPrice).divide(new BigDecimal("2")));
        } else if (BigDecimal.ZERO.compareTo(buyingPrice) == 0) {
            foreignMarketRate.set("middleprice", (Object)sellingPrice);
        } else if (BigDecimal.ZERO.compareTo(sellingPrice) == 0) {
            foreignMarketRate.set("middleprice", (Object)buyingPrice);
        }
        foreignMarketRate.set("name", (Object)String.format(ResManager.loadKDString((String)"%1$s\u5151\u6362%2$s", (String)"ForeignMarketRateSaveService_0", (String)"tmc-fbp-business", (Object[])new Object[0]), orCurrency, taCurrency));
    }
}

