/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.oppservice.pandamenu;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.OpBizRuleSetServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class PandaMenuUnRegisteService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selectors = super.getSelector();
        selectors.add("enable");
        selectors.add("number");
        selectors.add("schemeentry");
        selectors.add("bizbill");
        return selectors;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        Set billSet = Arrays.stream(dataEntities).flatMap(t -> t.getDynamicObjectCollection("schemeentry").stream().map(w -> w.getDynamicObject("bizbill").getString("number"))).collect(Collectors.toSet());
        List<Object> billIds = Arrays.stream(dataEntities).map(t -> t.get("id")).collect(Collectors.toList());
        Set<String> allBill = PandaMenuUnRegisteService.getAllBill(billIds);
        for (String billType : billSet) {
            if (allBill.contains(billType)) continue;
            TXHandle tx = TX.requiresNew();
            Throwable throwable = null;
            try {
                try {
                    OpBizRuleSetServiceHelper.deleteOpBizRuleSet((String)billType, (String)"PandaListCtrl");
                }
                catch (Throwable e) {
                    tx.markRollback();
                    throw e;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx == null) continue;
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                tx.close();
            }
        }
    }

    public static Set<String> getAllBill(List<Object> billIds) {
        String props = String.join((CharSequence)",", "number", "schemeentry.bizbill");
        QFilter filter = new QFilter("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue());
        filter.and("id", "not in", billIds);
        Map objectMap = TmcDataServiceHelper.loadFromCache((String)"fbd_pandamenu", (String)props, (QFilter[])new QFilter[]{filter});
        if (Objects.isNull(objectMap) || CollectionUtils.isEmpty(objectMap.keySet())) {
            return Collections.emptySet();
        }
        return objectMap.values().stream().map(t -> t.getDynamicObjectCollection("schemeentry")).flatMap(t -> t.stream().map(w -> w.getDynamicObject("bizbill").getString("number"))).collect(Collectors.toSet());
    }
}

