/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.oppservice.ratederivative;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;

public class RateDerivativeBatchSaveService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List list = super.getSelector();
        list.add("entry");
        list.add("type");
        list.add("referrate");
        list.add("publishtime");
        list.add("timezone");
        list.add("currency");
        list.add("enable");
        return list;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection("entry");
            ArrayList<DynamicObject> rateDericatives = new ArrayList<DynamicObject>(entry.size());
            String type = dataEntity.getString("type");
            DynamicObject referRate = dataEntity.getDynamicObject("referrate");
            DynamicObject currency = dataEntity.getDynamicObject("currency");
            DynamicObject timeZone = dataEntity.getDynamicObject("timezone");
            Integer publishTime = dataEntity.getInt("publishtime");
            Date creatTime = new Date();
            for (DynamicObject row : entry) {
                DynamicObject rateDericative = BusinessDataServiceHelper.newDynamicObject((String)"tbd_ratederivative");
                rateDericative.set("type", (Object)type);
                rateDericative.set("referrate", (Object)referRate);
                rateDericative.set("currency", (Object)currency);
                rateDericative.set("timezone", (Object)timeZone);
                rateDericative.set("publishtime", (Object)publishTime);
                rateDericative.set("createtime", (Object)creatTime);
                rateDericative.set("status", (Object)BillStatusEnum.AUDIT);
                rateDericative.set("enable", (Object)"1");
                rateDericative.set("name", (Object)row.getString("name"));
                rateDericative.set("number", (Object)row.getString("number"));
                switch (type) {
                    case "forward": {
                        rateDericative.set("fra", (Object)row.getString("fra"));
                        break;
                    }
                    case "futures": {
                        rateDericative.set("contract", (Object)row.getString("contract"));
                        break;
                    }
                    case "swap": {
                        rateDericative.set("term", (Object)row.getString("term"));
                    }
                }
                rateDericatives.add(rateDericative);
            }
            TmcOperateServiceHelper.execOperate((String)"save", (String)"tbd_ratederivative", (DynamicObject[])rateDericatives.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        }
    }
}

