/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.oppservice.referdata;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ReferDataBatchBaseSaveOppService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("entryentity");
        selector.add("referrate");
        selector.add("description");
        selector.add("bizdate");
        selector.add("endprice");
        selector.add("datasource");
        selector.add("modifytime");
        return super.getSelector();
    }

    public void process(DynamicObject[] paramArrayOfDynamicObject) throws KDException {
        HashMap<String, DynamicObject> dataMap = new HashMap<String, DynamicObject>(16);
        ArrayList referRateIds = new ArrayList(16);
        for (DynamicObject referRateBatchData : paramArrayOfDynamicObject) {
            DynamicObjectCollection entrys = referRateBatchData.getDynamicObjectCollection("entryentity");
            referRateIds.addAll(entrys.stream().map(row -> row.getDynamicObject("referrate")).filter(EmptyUtil::isNoEmpty).map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        }
        if (!CollectionUtils.isEmpty(referRateIds)) {
            DynamicObject[] dataRates;
            for (DynamicObject dataRate : dataRates = BusinessDataServiceHelper.load((String)"md_datarate", (String)"bizdate,referrate,description,datasource,endprice,modifytime", (QFilter[])new QFilter[]{new QFilter("referrate", "in", referRateIds)})) {
                Date bizDate = DateUtils.getDataFormat((Date)dataRate.getDate("bizdate"), (boolean)true);
                Object pkValue = dataRate.getDynamicObject("referrate").getPkValue();
                dataMap.put(bizDate.toString() + pkValue.toString(), dataRate);
            }
        }
        ArrayList<DynamicObject> waiteAddReferRate = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> waiteUpdateReferRate = new ArrayList<DynamicObject>(16);
        for (DynamicObject referRateBatchData : paramArrayOfDynamicObject) {
            DynamicObjectCollection entry = referRateBatchData.getDynamicObjectCollection("entryentity");
            for (DynamicObject row2 : entry) {
                DynamicObject referrate = row2.getDynamicObject("referrate");
                Date bizdate = row2.getDate("bizdate");
                DynamicObject referData = (DynamicObject)dataMap.get(bizdate.toString() + referrate.getPkValue());
                if (EmptyUtil.isEmpty((DynamicObject)referData)) {
                    referData = BusinessDataServiceHelper.newDynamicObject((String)"md_datarate");
                    referData.set("datasource", (Object)row2.getString("datasource"));
                    referData.set("status", (Object)BillStatusEnum.AUDIT.getValue());
                    referData.set("creator", (Object)RequestContext.get().getCurrUserId());
                    referData.set("enable", (Object)"1");
                    referData.set("createtime", (Object)DateUtils.getCurrentTime());
                    waiteAddReferRate.add(referData);
                } else {
                    waiteUpdateReferRate.add(referData);
                }
                referData.set("description", (Object)row2.getString("description"));
                referData.set("referrate", (Object)referrate);
                referData.set("bizdate", (Object)bizdate);
                referData.set("endprice", (Object)row2.getBigDecimal("endprice"));
                referData.set("modifytime", (Object)row2.getDate("modifytime"));
            }
        }
        if (!CollectionUtils.isEmpty(waiteAddReferRate)) {
            TmcOperateServiceHelper.execOperate((String)"save", (String)"md_datarate", (DynamicObject[])waiteAddReferRate.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        }
        if (!CollectionUtils.isEmpty(waiteUpdateReferRate)) {
            SaveServiceHelper.update((DynamicObject[])waiteUpdateReferRate.toArray(new DynamicObject[0]));
        }
    }
}

