/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.oppservice.release;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbd.common.enums.DebtBillTypeEnum;
import kd.tmc.fbd.common.enums.IntDataSource;
import kd.tmc.fbd.common.helper.SuretyBillHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.SuretyBizStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SuretyReleaseAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("suretybill");
        selector.add("amount");
        selector.add("entry");
        selector.add("repaydebt");
        selector.add("entry.debtcurrency");
        selector.add("entry.debttype");
        selector.add("entry.debtbillid");
        selector.add("suretystatus");
        selector.add("realrevenue");
        selector.add("releasedate");
        selector.add("apply");
        selector.add("sourcebillid");
        selector.add("isrevenue");
        selector.add("org");
        selector.add("currency");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        DynamicObject[] suretyBills;
        HashMap<Long, Map<Long, BigDecimal>> suretyIdDebitMap = new HashMap<Long, Map<Long, BigDecimal>>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            this.writeEntryDebtStatus(dataEntity.getDynamicObjectCollection("entry"));
            List debitBills = SuretyBillHelper.getWriteBackDebit((String)"release", (DynamicObject)dataEntity, (boolean)true);
            SaveServiceHelper.update((DynamicObject[])debitBills.toArray(new DynamicObject[0]));
            Map<Long, BigDecimal> debitBillMap = debitBills.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v.getBigDecimal("totalsuretymoney")));
            suretyIdDebitMap.put(dataEntity.getDynamicObject("suretybill").getLong("id"), debitBillMap);
        }
        Map<Long, DynamicObject> suretyIdReleaseMap = Arrays.stream(dataEntities).collect(Collectors.toMap(r -> (Long)r.getDynamicObject("suretybill").getPkValue(), r -> r));
        QFilter qFilter = new QFilter("id", "in", suretyIdReleaseMap.keySet());
        for (DynamicObject suretyBill : suretyBills = TmcDataServiceHelper.load((String)"fbd_suretybill", (String)"lastreleasedate,releaseamount,amount,surplusamount,bizstatus,totalamount,prefutureamt,revenue_entry,entry,entry.debttype,entry.debtbillid,entry.suretyamount", (QFilter[])qFilter.toArray())) {
            DynamicObject releaseBill = suretyIdReleaseMap.get(suretyBill.getLong("id"));
            this.setSrcSuretyBillValues(suretyBill, releaseBill);
            Map debitBillMap = (Map)suretyIdDebitMap.get(suretyBill.getLong("id"));
            DynamicObjectCollection entryCol = suretyBill.getDynamicObjectCollection("entry");
            List debitBills = entryCol.stream().filter(f -> DebtBillTypeEnum.LC_LETTERCREDIT.getValue().equals(f.getString("debttype")) && debitBillMap.containsKey(f.getLong("debtbillid"))).collect(Collectors.toList());
            for (DynamicObject debitBill : debitBills) {
                BigDecimal suretyAmount = (BigDecimal)debitBillMap.get(debitBill.getLong("debtbillid"));
                if (EmptyUtil.isEmpty((BigDecimal)suretyAmount)) continue;
                debitBill.set("suretyamount", (Object)suretyAmount);
            }
        }
        SaveServiceHelper.save((DynamicObject[])suretyBills);
    }

    private void writeEntryDebtStatus(DynamicObjectCollection entrys) {
        for (DynamicObject entry : entrys) {
            if (!entry.getBoolean("repaydebt")) continue;
            String bizType = entry.getString("debttype");
            String column = null;
            if (DebtBillTypeEnum.LC_LETTERCREDIT.getValue().equals(bizType)) {
                column = "creditstatus";
            } else if (DebtBillTypeEnum.CDM_PAYABLEBILL.getValue().equals(bizType)) {
                column = "draftbillstatus";
            } else if (DebtBillTypeEnum.GM_LETTEROFGUARANTEE.getValue().equals(bizType)) {
                column = "bizstatus";
            }
            DynamicObject bizBill = null;
            if (column != null) {
                bizBill = QueryServiceHelper.queryOne((String)bizType, (String)column, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)entry.getLong("debtbillid"))});
            }
            String debtStatus = SuretyBillHelper.getActDebtBizStatus(bizBill, (String)bizType);
            entry.set("suretystatus", (Object)debtStatus);
        }
    }

    private void setSrcSuretyBillValues(DynamicObject suretyBill, DynamicObject releaseBill) {
        suretyBill.set("lastreleasedate", (Object)releaseBill.getDate("releasedate"));
        BigDecimal releaseAmount = suretyBill.getBigDecimal("releaseamount").add(releaseBill.getBigDecimal("amount"));
        suretyBill.set("releaseamount", (Object)releaseAmount);
        BigDecimal finAmount = suretyBill.getBigDecimal("amount");
        BigDecimal surplusAmount = finAmount.subtract(releaseAmount);
        suretyBill.set("surplusamount", (Object)surplusAmount);
        if (BigDecimal.ZERO.compareTo(surplusAmount) == 0) {
            suretyBill.set("bizstatus", (Object)SuretyBizStatusEnum.SURETY_END.getValue());
            suretyBill.set("prefutureamt", (Object)BigDecimal.ZERO);
            suretyBill.getDynamicObjectCollection("revenue_entry").clear();
        } else {
            suretyBill.set("bizstatus", (Object)SuretyBizStatusEnum.SURETY_PART.getValue());
        }
        BigDecimal totalRevenue = suretyBill.getBigDecimal("totalamount").add(releaseBill.getBigDecimal("realrevenue"));
        suretyBill.set("totalamount", (Object)totalRevenue);
    }

    private void auditSuretySettleInt(DynamicObject[] dataEntities) {
        Set releaseIds = Arrays.stream(dataEntities).filter(rel -> rel.getBoolean("isrevenue")).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("sourcebillid", "in", releaseIds);
        qFilter.and(new QFilter("datasource", "=", (Object)IntDataSource.SETTLEINT.getValue()));
        qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.SUBMIT.getValue()));
        List revenueBills = QueryServiceHelper.queryPrimaryKeys((String)"fbd_surety_settleint", (QFilter[])qFilter.toArray(), null, (int)-1);
        if (EmptyUtil.isNoEmpty((Object)revenueBills)) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("releaseAudit", "true");
            Object[] revBillIds = revenueBills.toArray();
            TmcOperateServiceHelper.execOperate((String)"audit", (String)"fbd_surety_settleint", (Object[])revBillIds, (OperateOption)operateOption);
        }
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        this.auditSuretySettleInt(dataEntities);
    }
}

