/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.oppservice.release;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbd.common.enums.DebtBillTypeEnum;
import kd.tmc.fbd.common.enums.IntDataSource;
import kd.tmc.fbd.common.helper.RevenuePlanCalHelper;
import kd.tmc.fbd.common.helper.SuretyBillHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.SuretyBizStatusEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SuretyReleaseUnAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("suretybill");
        selector.add("amount");
        selector.add("realrevenue");
        selector.add("apply");
        selector.add("sourcebillid");
        selector.add("isrevenue");
        selector.add("org");
        selector.add("currency");
        selector.add("entry");
        selector.add("entry.debtcurrency");
        selector.add("entry.debttype");
        selector.add("entry.debtbillid");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        DynamicObject[] suretyBills;
        HashMap<Long, Map<Long, BigDecimal>> suretyIdDebitMap = new HashMap<Long, Map<Long, BigDecimal>>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            this.deleteSuretySettleInt(dataEntity);
            List debitBills = SuretyBillHelper.getWriteBackDebit((String)"release", (DynamicObject)dataEntity, (boolean)false);
            SaveServiceHelper.update((DynamicObject[])debitBills.toArray(new DynamicObject[0]));
            Map<Long, BigDecimal> debitBillMap = debitBills.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v.getBigDecimal("totalsuretymoney")));
            suretyIdDebitMap.put(dataEntity.getDynamicObject("suretybill").getLong("id"), debitBillMap);
        }
        Map<Long, DynamicObject> releaseBillMap = Arrays.stream(dataEntities).collect(Collectors.toMap(r -> r.getDynamicObject("suretybill").getLong("id"), r -> r));
        if (EmptyUtil.isEmpty(releaseBillMap)) {
            return;
        }
        for (DynamicObject suretyBill : suretyBills = TmcDataServiceHelper.load((String)"fbd_suretybill", (String)"billno,lastreleasedate,bizstatus,releaseamount,amount,org,currency,surplusamount,totalamount,entry,entry.debttype,entry.debtbillid,entry.debtcurrency,entry.suretyamount", (QFilter[])new QFilter("id", "in", releaseBillMap.keySet()).toArray())) {
            DynamicObject releaseBill = releaseBillMap.get(suretyBill.getLong("id"));
            if (EmptyUtil.isEmpty((DynamicObject)releaseBill)) continue;
            DynamicObject org = suretyBill.getDynamicObject("org");
            DynamicObject currency = suretyBill.getDynamicObject("currency");
            this.setSrcSuretyBillValues(suretyBill, releaseBill);
            Map debitBillMap = (Map)suretyIdDebitMap.get(suretyBill.getLong("id"));
            DynamicObjectCollection entryCol = suretyBill.getDynamicObjectCollection("entry");
            List debitBills = entryCol.stream().filter(f -> DebtBillTypeEnum.LC_LETTERCREDIT.getValue().equals(f.getString("debttype")) && debitBillMap.containsKey(f.getLong("debtbillid"))).collect(Collectors.toList());
            for (DynamicObject debitBill : debitBills) {
                DynamicObject debtCurrency = debitBill.getDynamicObject("debtcurrency");
                BigDecimal suretyAmount = (BigDecimal)debitBillMap.get(debitBill.getLong("debtbillid"));
                if (EmptyUtil.isEmpty((DynamicObject)debtCurrency) || EmptyUtil.isEmpty((BigDecimal)suretyAmount)) continue;
                BigDecimal exchangeRate = this.getRate(currency.getLong("id"), debtCurrency.getLong("id"), org.getLong("id"));
                debitBill.set("suretyamount", (Object)suretyAmount.multiply(exchangeRate));
            }
        }
        SaveServiceHelper.save((DynamicObject[])suretyBills);
    }

    private BigDecimal getRate(Long fromCurrencyId, Long tarCurrencyId, Long orgId) {
        if (fromCurrencyId.equals(tarCurrencyId)) {
            return BigDecimal.ONE;
        }
        BigDecimal rate = TmcBusinessBaseHelper.getExchangeRate((long)fromCurrencyId, (long)tarCurrencyId, (long)orgId, (Date)DateUtils.getCurrentDate());
        if (rate == null) {
            return BigDecimal.ONE;
        }
        return rate;
    }

    private void setSrcSuretyBillValues(DynamicObject suretyBill, DynamicObject releaseBill) {
        Date maxReleaseDate = SuretyReleaseUnAuditService.getMaxReleaseDate(suretyBill.getLong("id"), releaseBill.getLong("id"));
        suretyBill.set("lastreleasedate", (Object)maxReleaseDate);
        suretyBill.set("bizstatus", (Object)SuretyBizStatusEnum.SURETY_PART.getValue());
        BigDecimal curRedAmount = releaseBill.getBigDecimal("amount");
        BigDecimal releaseAmount = suretyBill.getBigDecimal("releaseamount").subtract(curRedAmount);
        suretyBill.set("releaseamount", (Object)releaseAmount);
        BigDecimal surAmount = suretyBill.getBigDecimal("surplusamount");
        BigDecimal calSurAmount = surAmount.add(curRedAmount);
        suretyBill.set("surplusamount", (Object)calSurAmount);
        if (releaseAmount.compareTo(BigDecimal.ZERO) == 0) {
            suretyBill.set("bizstatus", (Object)SuretyBizStatusEnum.SURETY_DONE.getValue());
        }
        BigDecimal totalRevenue = suretyBill.getBigDecimal("totalamount").subtract(releaseBill.getBigDecimal("realrevenue"));
        suretyBill.set("totalamount", (Object)totalRevenue);
    }

    public static Date getMaxReleaseDate(Long suretyBillId, Long releaseBillId) {
        QFilter qFilter = new QFilter("suretybill", "=", (Object)suretyBillId);
        qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and("id", "!=", (Object)releaseBillId);
        DynamicObjectCollection releaseCol = QueryServiceHelper.query((String)"fbd_suretyreleasebill", (String)"releasedate", (QFilter[])qFilter.toArray(), (String)"releasedate desc", (int)1);
        return EmptyUtil.isNoEmpty((DynamicObjectCollection)releaseCol) ? ((DynamicObject)releaseCol.get(0)).getDate("releasedate") : null;
    }

    private void deleteSuretySettleInt(DynamicObject dataEntity) {
        boolean isRevenue = dataEntity.getBoolean("isrevenue");
        if (!isRevenue) {
            return;
        }
        Long pkID = dataEntity.getLong("id");
        QFilter qFilter = new QFilter("sourcebillid", "=", (Object)pkID);
        qFilter.and(new QFilter("datasource", "=", (Object)IntDataSource.SETTLEINT.getValue()));
        DynamicObject revenueBill = QueryServiceHelper.queryOne((String)"fbd_surety_settleint", (String)"id", (QFilter[])qFilter.toArray());
        if (EmptyUtil.isEmpty((DynamicObject)revenueBill)) {
            return;
        }
        OperationResult result = TmcOperateServiceHelper.execOperate((String)"directdelete", (String)"fbd_surety_settleint", (Object[])new Object[]{revenueBill.get("id")}, (OperateOption)OperateOption.create());
        if (!result.isSuccess()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\u3002\u5220\u9664\u6536\u76ca\u5355\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f:%s\u3002", (String)"SuretyReleaseUnAuditService_1", (String)"tmc-fbd-business", (Object[])new Object[]{result.getMessage()}));
        }
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        super.beforeCommit(dataEntities);
        for (DynamicObject dataEntity : dataEntities) {
            boolean isRevenue = dataEntity.getBoolean("isrevenue");
            if (!isRevenue) continue;
            RevenuePlanCalHelper.calRevenuePlan((Long)dataEntity.getDynamicObject("suretybill").getLong("id"), (String)"fbd_surety_settleint", (Map)this.operationVariable);
        }
    }
}

