/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.oppservice.release;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SuretyRepayCancelService
extends AbstractTmcBizOppService {
    private static final String LC_CALLBACK_PROPS = "doneamount,todoamount,arrivalstatus";

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billstatus");
        selector.add("repaybillid");
        selector.add("amount");
        selector.add("totalamount");
        return selector;
    }

    public void process(DynamicObject[] dataEntity) throws KDException {
        for (DynamicObject suretyRelease : dataEntity) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("WF", "TRUE");
            operateOption.setVariableValue("ignorerepay", "true");
            ArrayList<String> optionKeys = new ArrayList<String>(3);
            String status = suretyRelease.getString("billstatus");
            if (BillStatusEnum.isAudit((String)status)) {
                optionKeys.add("unaudit");
            } else if (BillStatusEnum.isSubmit((String)status)) {
                optionKeys.add("unsubmit");
            }
            optionKeys.add("delete");
            for (String optionKey : optionKeys) {
                TmcOperateServiceHelper.execOperate((String)optionKey, (String)"fbd_suretyreleasebill", (Object[])new Object[]{suretyRelease.get("id")}, (OperateOption)operateOption);
            }
        }
    }

    public void beforeCommit(DynamicObject[] suretyReleases) throws KDException {
        super.beforeCommit(suretyReleases);
        if (EmptyUtil.isEmpty((Object[])suretyReleases)) {
            return;
        }
        String entityType = (String)this.getOperationVariable().get("debitType");
        if (StringUtils.equals((CharSequence)"lc_arrival", (CharSequence)entityType)) {
            SuretyRepayCancelService.writeBackLcArrival(suretyReleases);
        }
    }

    private static void writeBackLcArrival(DynamicObject[] suretyReleases) {
        DynamicObject arrival = TmcDataServiceHelper.loadSingle((String)"lc_arrival", (String)LC_CALLBACK_PROPS, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)suretyReleases[0].getLong("repaybillid"))});
        BigDecimal totalRepayAmt = Arrays.stream(suretyReleases).map(d -> d.getBigDecimal("totalamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (StringUtils.equals((CharSequence)"arrival_pay", (CharSequence)arrival.getString("arrivalstatus"))) {
            arrival.set("arrivalstatus", (Object)"arrival_confirm");
        }
        arrival.set("doneamount", (Object)arrival.getBigDecimal("doneamount").subtract(totalRepayAmt));
        arrival.set("todoamount", (Object)arrival.getBigDecimal("todoamount").add(totalRepayAmt));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{arrival});
    }
}

