/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.oppservice.subscribe;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.OpBizRuleSetServiceHelper;
import kd.tmc.fbd.common.helper.SubscribeHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SubscribeTemplateSaveService
extends AbstractTmcBizOppService {
    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObject dataSource = dataEntity.getDynamicObject("datasource");
            Set subScribeSet = SubscribeHelper.getSubscribeOps((String)dataSource.getString("id"), (long)dataEntity.getLong("id"));
            String subScribeOps = dataEntity.getString("subscribeop");
            subScribeSet.addAll(Arrays.stream(subScribeOps.split(",")).filter(EmptyUtil::isNoEmpty).collect(Collectors.toList()));
            try (TXHandle tx = TX.requiresNew();){
                try {
                    OpBizRuleSetServiceHelper.saveOpBizRuleSet((String)dataSource.getString("number"), (String)"tmcSubsribe", new ArrayList(subScribeSet));
                }
                catch (Throwable e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
    }
}

