/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.oppservice.surety;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbd.common.helper.SuretyHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SuretyBillDeleteService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("entry_credit");
        selector.add("entry");
        selector.add("creditbillid");
        selector.add("debtbillid");
        selector.add("debttype");
        return selector;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        ArrayList<DynamicObject> offIsSuretyCredits = new ArrayList<DynamicObject>(dynamicObjects.length);
        for (DynamicObject suretyBill : dynamicObjects) {
            SuretyBillDeleteService.writeBackIsSurety(offIsSuretyCredits, suretyBill);
        }
        if (EmptyUtil.isNoEmpty(offIsSuretyCredits)) {
            SaveServiceHelper.save((DynamicObject[])offIsSuretyCredits.toArray(new DynamicObject[offIsSuretyCredits.size()]));
        }
        SuretyHelper.writeBackToBizBill((DynamicObject[])dynamicObjects, (boolean)false);
    }

    private static void writeBackIsSurety(List<DynamicObject> offIsSuretyCredits, DynamicObject suretyBill) {
        DynamicObjectCollection credits = suretyBill.getDynamicObjectCollection("entry_credit");
        DynamicObjectCollection debits = suretyBill.getDynamicObjectCollection("entry");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)credits)) {
            Object[] creditIds = credits.stream().map(d -> d.getDynamicObject("creditbillid").getPkValue()).collect(Collectors.toList()).toArray();
            DynamicObject[] creditLimits = TmcDataServiceHelper.load((String)"cfm_creditlimit", (String)"issurety", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)creditIds)});
            Arrays.stream(creditLimits).forEach(d -> d.set("issurety", (Object)false));
            offIsSuretyCredits.addAll(Arrays.asList(creditLimits));
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)debits)) {
            Map<Long, String> debitMap = debits.stream().collect(Collectors.toMap(d -> d.getLong("debtbillid"), v -> v.getString("debttype"), (key1, key2) -> key1));
            Map debitTypesAndIdMap = debitMap.entrySet().stream().collect(Collectors.groupingBy(Map.Entry::getValue, Collectors.mapping(Map.Entry::getKey, Collectors.toList())));
            SuretyHelper.removeNotWriteBack(debitTypesAndIdMap);
            for (Map.Entry debit : debitTypesAndIdMap.entrySet()) {
                DynamicObject[] debitBills = TmcDataServiceHelper.load((String)debit.getKey(), (String)"issurety", (QFilter[])new QFilter[]{new QFilter("id", "in", debitTypesAndIdMap.get(debit.getKey()))});
                Arrays.stream(debitBills).forEach(d -> d.set("issurety", (Object)false));
                offIsSuretyCredits.addAll(Arrays.asList(debitBills));
            }
        }
    }
}

