/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.oppservice.surety;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.tmc.fbd.common.helper.RevenuePlanCalHelper;
import kd.tmc.fbd.common.helper.SuretyHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.DateUtils;

public class SuretyBillSaveService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("suretybill");
        selector.add("surplusamount");
        selector.add("amount");
        selector.add("intdate");
        selector.add("expiredate");
        selector.add("entry_credit");
        selector.add("investvarieties");
        selector.add("creditbillid");
        selector.add("debtbillid");
        selector.add("debttype");
        selector.add("entry");
        return selector;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        HashMap isSuretyOnMap = new HashMap(16);
        HashMap isSuretyOffMap = new HashMap(16);
        for (DynamicObject suretyBill : dynamicObjects) {
            suretyBill.set("surplusamount", (Object)suretyBill.getBigDecimal("amount"));
            suretyBill.set("intdate", (Object)DateUtils.truncateDate((Date)suretyBill.getDate("intdate")));
            suretyBill.set("expiredate", (Object)DateUtils.truncateDate((Date)suretyBill.getDate("expiredate")));
            SuretyHelper.writeBackIsSurety((DynamicObject)suretyBill, isSuretyOnMap, isSuretyOffMap);
        }
        SuretyHelper.writeBackToDB(isSuretyOnMap, isSuretyOffMap);
        SuretyHelper.writeBackToBizBill((DynamicObject[])dynamicObjects, (boolean)true);
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        super.beforeCommit(dataEntities);
        for (DynamicObject dataEntity : dataEntities) {
            Long suretyBillId = dataEntity.getLong("id");
            RevenuePlanCalHelper.calRevenuePlan((Long)suretyBillId, (String)"fbd_suretybill", (Map)this.operationVariable);
        }
    }
}

