/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.oppservice.surety;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;

public class SuretyBillUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(SuretyBillUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        try (TXHandle handle = TX.requiresNew();){
            try {
                logger.info("start upgrade suretybillupgrade type and value");
                this.dataUpgradeAppend();
                this.dataUpgradeRelease();
                logger.info("end upgrade suretybillupgrade type and value");
            }
            catch (Exception e) {
                result.setErrorInfo(e.getMessage());
                result.setSuccess(false);
                logger.info(e.getMessage());
            }
        }
        return result;
    }

    private void dataUpgradeRelease() {
        String releaseQuerySql = "select tfs.fid,tfse.fdebtbillid,tfse.fbizno from t_fbd_suretybill tfs,t_fbd_suretybill_e tfse where tfs.fid=tfse.fid";
        DataSet releaseData = DB.queryDataSet((String)"SuretyBillUpgradeService", (DBRoute)DBRouteConst.TMC, (String)releaseQuerySql);
        if (!releaseData.isEmpty()) {
            StringBuilder releaseBuilder = new StringBuilder();
            for (Row releaseDatum : releaseData.copy()) {
                releaseBuilder.append(releaseDatum.getLong("fid")).append(",");
            }
            String releaseIdStr = releaseBuilder.toString();
            releaseIdStr = releaseIdStr.length() > 0 ? releaseIdStr.substring(0, releaseIdStr.length() - 1) : releaseIdStr;
            String entityQuerySql = "select ftableid from t_meta_entityinfo where fid = 'fbd_suretyreleasebill'";
            DataSet entityData = DB.queryDataSet((String)"SuretyBillUpgradeService", (DBRoute)DBRouteConst.META, (String)entityQuerySql);
            StringBuilder releaseTableBuilder = new StringBuilder();
            for (Row entityDatum : entityData.copy()) {
                releaseTableBuilder.append(entityDatum.getLong("ftableid")).append(",");
            }
            String releaseTableIdStr = releaseTableBuilder.toString();
            releaseTableIdStr = releaseTableIdStr.length() > 0 ? releaseTableIdStr.substring(0, releaseTableIdStr.length() - 1) : releaseTableIdStr;
            String trackerQuerySql = "select fsbillid,ftbillid from t_botp_billtracker where fttableid in (" + releaseTableIdStr + ") and fsbillid in (" + releaseIdStr + ")";
            DataSet trackerData = DB.queryDataSet((String)"SuretyBillUpgradeService", (DBRoute)DBRouteConst.SYS, (String)trackerQuerySql);
            HashMap<Long, HashSet<Long>> trackerMap = new HashMap<Long, HashSet<Long>>(100);
            for (Row trackerDatum : trackerData.copy()) {
                HashSet<Long> temp = (HashSet<Long>)trackerMap.get(trackerDatum.getLong("fsbillid"));
                if (temp == null) {
                    temp = new HashSet<Long>(16);
                }
                temp.add(trackerDatum.getLong("ftbillid"));
                trackerMap.put(trackerDatum.getLong("fsbillid"), temp);
            }
            ArrayList<Object[]> batchParam = new ArrayList<Object[]>(100);
            for (Row releaseDatum : releaseData.copy()) {
                Set temp = (Set)trackerMap.get(releaseDatum.getLong("fid"));
                if (temp == null || temp.isEmpty()) continue;
                for (Long releaseId : temp) {
                    batchParam.add(new Object[]{releaseDatum.getString("fbizno"), releaseId, releaseDatum.getLong("fdebtbillid")});
                }
            }
            if (!batchParam.isEmpty()) {
                DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)"update t_fbd_suretybill_e set fbizno=? where fid=? and fdebtbillid=?", batchParam);
            }
        }
    }

    private void dataUpgradeAppend() {
        String appendQuerySql = "select tfsa.fid,tfsa.forgid,tfsa.fbizdate,tfse.fdebtcurrencyid,tfse.fcreditcurrencyid,tfse.freleasecreditamt from t_fbd_surety_append tfsa,t_fbd_suretybill_e tfse where tfsa.fid=tfse.fid and (tfse.fappendamt is null or tfse.fappendamt=0) and tfse.fcreditcurrencyid!=0";
        DataSet appendData = DB.queryDataSet((String)"SuretyBillUpgradeService", (DBRoute)DBRouteConst.TMC, (String)appendQuerySql);
        if (!appendData.isEmpty()) {
            ArrayList<Object[]> batchParam = new ArrayList<Object[]>(16);
            for (Row appendDatum : appendData.copy()) {
                BigDecimal exchangeRate = SuretyBillUpgradeService.getRate(appendDatum.getLong("fcreditcurrencyid"), appendDatum.getLong("forgid"), appendDatum.getLong("fdebtcurrencyid"), appendDatum.getDate("fbizdate"));
                batchParam.add(new Object[]{appendDatum.getBigDecimal("freleasecreditamt").multiply(exchangeRate), appendDatum.getLong("fid")});
            }
            DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)"update t_fbd_suretybill_e set fappendamt=? where fid=?", batchParam);
        }
    }

    private static BigDecimal getRate(Long currencyId, Long debtOrgId, Long debtCurrencyId, Date applyDate) {
        BigDecimal exchangeRate = BigDecimal.ONE;
        if (!currencyId.equals(debtCurrencyId)) {
            exchangeRate = TmcBusinessBaseHelper.getExchangeRate((long)currencyId, (long)debtCurrencyId, (long)debtOrgId, (Date)applyDate);
        }
        return exchangeRate == null ? BigDecimal.ONE : exchangeRate;
    }
}

