/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.oppservice.suretypreint;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SuretyPreIntBatchAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("bizdate");
        selector.add("operateType");
        selector.add("entry");
        selector.add("entry.status");
        selector.add("entry.startdate");
        selector.add("entry.interestamt");
        selector.add("entry.actualinstamt");
        selector.add("entry.loanbillno");
        selector.add("entry.loanbillid");
        selector.add("entry.intdetail_tag");
        selector.add("entry.intbillid");
        selector.add("entry.intdetailnum");
        selector.add("entry.intcomment");
        selector.add("entry.enddate");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject batchPreIntBill : dataEntities) {
            batchPreIntBill.getDynamicObjectCollection("entry").stream().forEach(dyn -> SuretyPreIntBatchAuditService.doAuditPreIntBill(dyn));
            this.writeBackLoanBill(batchPreIntBill);
        }
    }

    public static void doAuditPreIntBill(DynamicObject batchPreIntEntry) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("WF", "TRUE");
        try {
            Object intBillId = batchPreIntEntry.get("intbillid");
            TmcOperateServiceHelper.execOperate((String)"audit", (String)"fbd_surety_preint", (Object[])new Object[]{intBillId}, (OperateOption)option, (boolean)true);
            batchPreIntEntry.set("intcomment", (Object)"");
            batchPreIntEntry.set("status", (Object)"success");
        }
        catch (Exception e) {
            batchPreIntEntry.set("status", (Object)"fail");
            batchPreIntEntry.set("intcomment", (Object)String.format(ResManager.loadKDString((String)"\u4fdd\u8bc1\u91d1\u9884\u63d0\u5229\u606f\u5355\u5ba1\u6838\u5931\u8d25\uff1a%s", (String)"SuretyPreIntBatchAuditService_1", (String)"tmc-fbd-business", (Object[])new Object[0]), e.getMessage().length() > 50 ? e.getMessage().substring(0, 40) : e.getMessage()));
        }
    }

    private void writeBackLoanBill(DynamicObject batchPreIntBill) {
        DynamicObjectCollection entrys = batchPreIntBill.getDynamicObjectCollection("entry");
        List loanNumbers = entrys.stream().map(v -> v.getString("loanbillno")).collect(Collectors.toList());
        DynamicObject[] loanBills = TmcDataServiceHelper.load((String)"fbd_suretybill", (String)"billno,endpreinstdate", (QFilter[])new QFilter[]{new QFilter("billno", "in", loanNumbers)});
        Map<Object, DynamicObject> loanBillMap = Arrays.stream(loanBills).collect(Collectors.toMap(v -> v.getString("billno"), v -> v));
        entrys.stream().filter(v -> EmptyUtil.isNoEmpty((String)v.getString("loanbillno"))).forEach(row -> {
            String status = row.getString("status");
            if (!StringUtils.equals((CharSequence)"fail", (CharSequence)status)) {
                String loannum = row.getString("loanbillno");
                DynamicObject loanBill = (DynamicObject)loanBillMap.get(loannum);
                loanBill.set("endpreinstdate", (Object)row.getDate("enddate"));
            }
        });
        SaveServiceHelper.save((DynamicObject[])loanBills);
    }
}

