/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.oppservice.suretypreint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class SuretyPreIntBatchSubmitService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("bizdate");
        selector.add("operateType");
        selector.add("entry");
        selector.add("entry.status");
        selector.add("entry.startdate");
        selector.add("entry.interestamt");
        selector.add("entry.actualinstamt");
        selector.add("entry.loanbillno");
        selector.add("entry.loanbillid");
        selector.add("entry.intdetail_tag");
        selector.add("entry.intbillid");
        selector.add("entry.intdetailnum");
        selector.add("entry.intcomment");
        selector.add("entry.enddate");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject batchPreIntBill : dataEntities) {
            DynamicObjectCollection batchPreIntEntrys = batchPreIntBill.getDynamicObjectCollection("entry");
            this.doPushByPreIntEntry(batchPreIntBill, batchPreIntEntrys);
        }
    }

    private void checkFail(List intBillIds, DynamicObject batchIntBill, DynamicObjectCollection batchInEntrys) {
        if (intBillIds.size() < batchInEntrys.size()) {
            DynamicObjectCollection batchEntrys = batchIntBill.getDynamicObjectCollection("entry");
            for (DynamicObject intEntry : batchEntrys) {
                if (!intBillIds.contains(intEntry.getLong("intbillid"))) continue;
                intEntry.set("status", (Object)"");
                intEntry.set("intdetailnum", null);
                intEntry.set("intbillid", null);
            }
            batchIntBill.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
            TmcOperateServiceHelper.execOperate((String)"save", (String)batchIntBill.getDataEntityType().getName(), (DynamicObject[])new DynamicObject[]{batchIntBill}, (OperateOption)OperateOption.create(), (boolean)true);
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u63a8\u4fdd\u8bc1\u91d1\u9884\u63d0\u5355\u5931\u8d25\uff1a\u6709\u63d0\u4ea4\u5931\u8d25\u7684\u8bb0\u5f55\uff0c\u8bf7\u91cd\u65b0\u63d0\u4ea4\uff0c\u6216\u8005\u5220\u9664\u3002", (String)"SuretyPreIntBatchSubmitService_2", (String)"tmc-fbd-business", (Object[])new Object[0]));
        }
    }

    private void doPushByPreIntEntry(DynamicObject batchPreIntBill, DynamicObjectCollection entrys) {
        if (CollectionUtils.isEmpty((Collection)entrys)) {
            return;
        }
        List loanBillIds = entrys.stream().map(v -> v.getLong("loanbillid")).collect(Collectors.toList());
        Pair pair = Pair.of((Object)"fbd_suretybill", (Object)"fbd_surety_preint");
        String entityName = (String)pair.getLeft();
        DynamicObject[] loanBills = TmcDataServiceHelper.load((Object[])loanBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
        Map<Object, DynamicObject> loanBillsMap = Arrays.stream(loanBills).collect(Collectors.toMap(DataEntityBase::getPkValue, v -> v));
        ArrayList intBillIds = new ArrayList(entrys.size());
        List ids = Arrays.stream(loanBills).map(Dyn -> Dyn.getPkValue().toString()).collect(Collectors.toList());
        Map LimitMap = MutexServiceHelper.batchRequest(ids, (String)((String)pair.getLeft()), (String)"submit");
        List lockIds = LimitMap.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toList());
        try {
            String lockErrorBillNos = entrys.stream().filter(b -> Boolean.FALSE.equals(LimitMap.get(b.getString("loanbillid")))).map(b -> b.getString("loanbillno")).collect(Collectors.joining(","));
            if (EmptyUtil.isNoEmpty((String)lockErrorBillNos)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u6b63\u5728\u4e0b\u63a8\u4fdd\u8bc1\u91d1\u9884\u63d0\u5229\u606f\u5355, \u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"SuretyPreIntBatchSubmitService_0", (String)"tmc-fbd-business", (Object[])new Object[0]), lockErrorBillNos));
            }
            for (DynamicObject batchPreIntEntry : entrys) {
                SuretyPreIntBatchSubmitService.pushEntryLoanBill(batchPreIntBill, (Pair<String, String>)pair, loanBillsMap, batchPreIntEntry, intBillIds);
            }
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0b\u63a8\u4fdd\u8bc1\u91d1\u9884\u63d0\u5229\u606f\u5355\u5931\u8d25:%s\u3002", (String)"SuretyPreIntBatchSubmitService_1", (String)"tmc-fbd-business", (Object[])new Object[0]), e.getMessage()));
        }
        finally {
            if (!lockIds.isEmpty()) {
                MutexServiceHelper.batchRelease(lockIds, (String)((String)pair.getLeft()), (String)"submit");
            }
        }
        this.checkFail(intBillIds, batchPreIntBill, entrys);
    }

    private static void pushEntryLoanBill(DynamicObject batchPreIntBill, Pair<String, String> pair, Map<Object, DynamicObject> loanBillsMap, DynamicObject batchPreIntEntry, List intBillIds) {
        DynamicObject loanBill = loanBillsMap.get(batchPreIntEntry.get("loanbillid"));
        Date bizDate = batchPreIntBill.getDate("bizdate");
        DynamicObject[] targetBills = TmcBotpHelper.push((DynamicObject)loanBill, (String)((String)pair.getRight()));
        targetBills[0].getDynamicObjectCollection("entrys").clear();
        targetBills[0].set("bizdate", (Object)bizDate);
        targetBills[0].set("operatetype", (Object)batchPreIntBill.getString("operateType"));
        targetBills[0].set("prestartdate", (Object)batchPreIntEntry.getDate("startdate"));
        targetBills[0].set("prestenddate", (Object)bizDate);
        targetBills[0].set("surplusamount", (Object)loanBill.getBigDecimal("surplusamount"));
        targetBills[0].set("intdate", (Object)loanBill.getDate("intdate"));
        targetBills[0].set("predictpreinstamt", (Object)batchPreIntEntry.getBigDecimal("interestamt"));
        targetBills[0].set("actpreinstamt", (Object)batchPreIntEntry.getBigDecimal("actualinstamt"));
        SuretyPreIntBatchSubmitService.setTargetBillEntry(targetBills[0], batchPreIntEntry.getString("intdetail_tag"));
        SuretyPreIntBatchSubmitService.doSavePreIntBill(batchPreIntEntry, targetBills, intBillIds);
    }

    public static void doSavePreIntBill(DynamicObject batchPreIntEntry, DynamicObject[] targetBills, List intBillIds) {
        if (EmptyUtil.isEmpty((Object[])targetBills)) {
            return;
        }
        String entityName = targetBills[0].getDataEntityType().getName();
        OperationResult result = null;
        OperateOption option = OperateOption.create();
        option.setVariableValue("WF", "TRUE");
        try {
            result = TmcOperateServiceHelper.execOperate((String)"submit", (String)entityName, (DynamicObject[])targetBills, (OperateOption)option, (boolean)false);
        }
        catch (Exception e) {
            batchPreIntEntry.set("status", (Object)"fail");
            batchPreIntEntry.set("intcomment", (Object)String.format(ResManager.loadKDString((String)"\u4fdd\u8bc1\u91d1\u9884\u63d0\u5229\u606f\u5355\u751f\u6210\u5931\u8d25\uff1a%s", (String)"SuretyPreIntBatchAuditService_0", (String)"tmc-fbd-business", (Object[])new Object[0]), e.getMessage().length() > 50 ? e.getMessage().substring(0, 40) : e.getMessage()));
        }
        if (result == null) {
            return;
        }
        Object intBillId = result.getSuccessPkIds().toArray()[0];
        if (EmptyUtil.isNoEmpty((Object)result.getBillNos())) {
            batchPreIntEntry.set("intdetailnum", result.getBillNos().values().toArray()[0]);
            batchPreIntEntry.set("intbillid", intBillId);
            intBillIds.add(intBillId);
        }
        batchPreIntEntry.set("intcomment", (Object)"");
        batchPreIntEntry.set("status", (Object)"success");
    }

    private static void setTargetBillEntry(DynamicObject targetBill, String detailTagInfo) {
        IntBillInfo intBillInfo = (IntBillInfo)SerializationUtils.fromJsonString((String)detailTagInfo, IntBillInfo.class);
        DynamicObjectCollection entryCol = targetBill.getDynamicObjectCollection("entrys");
        entryCol.clear();
        List details = intBillInfo.getDetails();
        for (IntBillDetailInfo detailInfo : details) {
            DynamicObject newEntry = entryCol.addNew();
            newEntry.set("inststartdate", (Object)detailInfo.getBeginDate());
            newEntry.set("instenddate", (Object)detailInfo.getEndDate());
            newEntry.set("instdays", (Object)detailInfo.getDays());
            newEntry.set("instprincipalamt", (Object)detailInfo.getPrinciple());
            newEntry.set("rate", (Object)detailInfo.getRate());
            newEntry.set("ratetrandays", (Object)detailInfo.getBasisDay());
            newEntry.set("instamt", (Object)detailInfo.getAmount());
        }
    }
}

