/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.oppservice.suretypreint;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbd.common.enums.PreIntOperateTypeEnum;
import kd.tmc.fbd.common.enums.WriteOffStatusEnum;
import kd.tmc.fbd.common.helper.RevenuePlanCalHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;

public class SuretyPreIntRedWriteOffService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        HashSet<Long> loanBillIds = new HashSet<Long>(0);
        List pks = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)dataEntities[0].getDynamicObjectType().getName());
        DynamicObject[] preInts = TmcDataServiceHelper.load((Object[])pks.toArray(), (DynamicObjectType)entityType);
        ArrayList<DynamicObject> redWriteOffPreInt = new ArrayList<DynamicObject>(dataEntities.length);
        Long userId = RequestContext.get().getCurrUserId();
        for (DynamicObject preInt : preInts) {
            DynamicObject newPreInt = TmcDataServiceHelper.clone((DynamicObject)preInt);
            newPreInt.set("billhead_lk", null);
            newPreInt.set("billno", (Object)"");
            newPreInt.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
            newPreInt.set("writeoffpreintbillid", preInt.getPkValue());
            newPreInt.set("operatetype", (Object)PreIntOperateTypeEnum.REVERSEINT.getValue());
            newPreInt.set("writeoffamt", preInt.get("actpreinstamt"));
            newPreInt.set("nowriteoffamt", (Object)BigDecimal.ZERO);
            newPreInt.set("createtime", (Object)new Date());
            newPreInt.set("creator", (Object)TmcDataServiceHelper.loadSingleFromCache((Object)userId, (String)"bos_user"));
            newPreInt.set("writeoffstatus", (Object)WriteOffStatusEnum.RED_WRITEOFF.getValue());
            redWriteOffPreInt.add(newPreInt);
            preInt.set("writeoffstatus", (Object)WriteOffStatusEnum.RED_WRITEOFF.getValue());
            preInt.set("writeoffamt", preInt.get("actpreinstamt"));
            preInt.set("nowriteoffamt", (Object)BigDecimal.ZERO);
            preInt.set("modifier", (Object)userId);
            preInt.set("modifytime", (Object)new Date());
            loanBillIds.add(preInt.getLong("sourcebillid"));
        }
        OperateOption opOption = OperateOption.create();
        opOption.setVariableValue("redwriteoffop", "redwriteoffop");
        OperationResult submitRes = TmcOperateServiceHelper.execOperate((String)"submit", (String)dataEntities[0].getDataEntityType().getName(), (DynamicObject[])redWriteOffPreInt.toArray(new DynamicObject[0]), (OperateOption)opOption);
        List redWriteOffPreIntPkIds = submitRes.getSuccessPkIds();
        TmcOperateServiceHelper.execOperate((String)"audit", (String)dataEntities[0].getDataEntityType().getName(), (Object[])redWriteOffPreIntPkIds.toArray(), (OperateOption)opOption);
        SaveServiceHelper.save((DynamicObject[])preInts);
        RevenuePlanCalHelper.writeBackLastPreIntDate(loanBillIds);
    }
}

