/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.oppservice.suretystlint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbd.common.helper.SuretyBillHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class SuretySettleIntBatchSubmitService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("bizdate");
        selector.add("revenuetype");
        selector.add("entry");
        selector.add("entry.status");
        selector.add("entry.startdate");
        selector.add("entry.interestamt");
        selector.add("entry.actualinstamt");
        selector.add("entry.intdetail_tag");
        selector.add("entry.loanbillno");
        selector.add("entry.loanbillid");
        selector.add("entry.enddate");
        selector.add("entry.currency");
        selector.add("entry.intbillid");
        selector.add("entry.intdetailnum");
        selector.add("entry.intcomment");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject batchIntBill : dataEntities) {
            DynamicObjectCollection batchIntEntrys = batchIntBill.getDynamicObjectCollection("entry");
            this.doPushByIntEntry(batchIntBill, batchIntEntrys);
        }
    }

    private void checkFail(List intBillIds, DynamicObject batchIntBill, DynamicObjectCollection batchInEntrys) {
        if (intBillIds.size() < batchInEntrys.size()) {
            DynamicObjectCollection batchEntrys = batchIntBill.getDynamicObjectCollection("entry");
            for (DynamicObject intEntry : batchEntrys) {
                if (!intBillIds.contains(intEntry.getLong("intbillid"))) continue;
                intEntry.set("status", (Object)"");
                intEntry.set("intdetailnum", null);
                intEntry.set("intbillid", null);
            }
            batchIntBill.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
            TmcOperateServiceHelper.execOperate((String)"save", (String)batchIntBill.getDataEntityType().getName(), (DynamicObject[])new DynamicObject[]{batchIntBill}, (OperateOption)OperateOption.create(), (boolean)true);
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u63a8\u4fdd\u8bc1\u91d1\u6536\u76ca\u5355\u5931\u8d25\uff1a\u6709\u63d0\u4ea4\u5931\u8d25\u7684\u8bb0\u5f55\uff0c\u8bf7\u91cd\u65b0\u63d0\u4ea4\uff0c\u6216\u8005\u5220\u9664\u3002", (String)"SuretySettleIntBatchSubmitService_2", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
    }

    private void doPushByIntEntry(DynamicObject batchIntBill, DynamicObjectCollection entrys) {
        if (CollectionUtils.isEmpty((Collection)entrys)) {
            return;
        }
        Object[] suretyBillIds = entrys.stream().map(v -> v.getLong("loanbillid")).toArray();
        Pair pair = Pair.of((Object)"fbd_suretybill", (Object)"fbd_surety_settleint");
        String entityName = (String)pair.getLeft();
        DynamicObject[] suretyBills = TmcDataServiceHelper.load((Object[])suretyBillIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
        Map<Object, DynamicObject> suretyBillsMap = Arrays.stream(suretyBills).collect(Collectors.toMap(DataEntityBase::getPkValue, v -> v));
        ArrayList intBillIds = new ArrayList(entrys.size());
        List ids = Arrays.stream(suretyBills).map(Dyn -> Dyn.getPkValue().toString()).collect(Collectors.toList());
        Map LimitMap = MutexServiceHelper.batchRequest(ids, (String)((String)pair.getLeft()), (String)"submit");
        List lockIds = LimitMap.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toList());
        try {
            String lockErrorBillNos = entrys.stream().filter(b -> Boolean.FALSE.equals(LimitMap.get(b.getString("loanbillid")))).map(b -> b.getString("loanbillno")).collect(Collectors.joining(","));
            if (EmptyUtil.isNoEmpty((String)lockErrorBillNos)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u6b63\u5728\u4e0b\u63a8\u4fdd\u8bc1\u91d1\u6536\u76ca\u5355, \u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"SuretySettleIntBatchSubmitService_0", (String)"tmc-fbd-business", (Object[])new Object[0]), lockErrorBillNos));
            }
            for (DynamicObject batchIntEntry : entrys) {
                SuretySettleIntBatchSubmitService.pushEntryLoanBill(batchIntBill, (Pair<String, String>)pair, suretyBillsMap, batchIntEntry, intBillIds);
            }
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0b\u63a8\u4fdd\u8bc1\u91d1\u6536\u76ca\u5931\u8d25:%s\u3002", (String)"SuretySettleIntBatchSubmitService_1", (String)"tmc-fbd-business", (Object[])new Object[0]), e.getMessage()));
        }
        finally {
            if (!lockIds.isEmpty()) {
                MutexServiceHelper.batchRelease(lockIds, (String)((String)pair.getLeft()), (String)"submit");
            }
        }
        this.checkFail(intBillIds, batchIntBill, entrys);
    }

    private static void pushEntryLoanBill(DynamicObject batchIntBill, Pair<String, String> pair, Map<Object, DynamicObject> suretyBillsMap, DynamicObject batchIntEntry, List intBillIds) {
        DynamicObject suretyBill = suretyBillsMap.get(batchIntEntry.get("loanbillid"));
        DynamicObject[] targetBills = TmcBotpHelper.push((DynamicObject)suretyBill, (String)((String)pair.getRight()));
        DynamicObject targetBill = targetBills[0];
        targetBill.getDynamicObjectCollection("entrys").clear();
        DynamicObject productFactory = suretyBill.getDynamicObject("productfactory");
        Date bizDate = batchIntBill.getDate("bizdate");
        targetBill.set("bizdate", (Object)bizDate);
        targetBill.set("prestenddate", (Object)SuretyBillHelper.getEndIntDate((DynamicObject)productFactory, (Date)bizDate));
        targetBill.set("revenuetype", (Object)batchIntBill.getString("revenuetype"));
        targetBill.set("prestartdate", (Object)batchIntEntry.getDate("startdate"));
        targetBill.set("predictpreinstamt", (Object)batchIntEntry.getBigDecimal("interestamt"));
        targetBill.set("actpreinstamt", (Object)batchIntEntry.getBigDecimal("actualinstamt"));
        SuretySettleIntBatchSubmitService.setTargetBillEntry(targetBill, batchIntEntry.getString("intdetail_tag"));
        SuretySettleIntBatchSubmitService.doSaveIntBill(batchIntEntry, targetBills, intBillIds);
    }

    public static void doSaveIntBill(DynamicObject batchIntEntry, DynamicObject[] targetBills, List intBillIds) {
        if (EmptyUtil.isEmpty((Object[])targetBills)) {
            return;
        }
        String entityName = targetBills[0].getDataEntityType().getName();
        OperationResult result = null;
        OperateOption option = OperateOption.create();
        option.setVariableValue("WF", "TRUE");
        try {
            result = TmcOperateServiceHelper.execOperate((String)"submit", (String)entityName, (DynamicObject[])targetBills, (OperateOption)option, (boolean)true);
        }
        catch (Exception e) {
            batchIntEntry.set("status", (Object)"fail");
            batchIntEntry.set("intcomment", (Object)ResManager.loadKDString((String)"\u4fdd\u8bc1\u91d1\u6536\u76ca\u5355\u751f\u6210\u5931\u8d25\uff1a%s", (String)"SuretySettleIntBatchAuditService_0", (String)"tmc-fbd-business", (Object[])new Object[]{e.getMessage().length() > 50 ? e.getMessage().substring(0, 40) : e.getMessage()}));
        }
        if (result == null) {
            return;
        }
        Object intBillId = result.getSuccessPkIds().toArray()[0];
        if (EmptyUtil.isNoEmpty((Object)result.getBillNos())) {
            batchIntEntry.set("intdetailnum", result.getBillNos().values().toArray()[0]);
            batchIntEntry.set("intbillid", intBillId);
            intBillIds.add(intBillId);
        }
        batchIntEntry.set("intcomment", (Object)"");
        batchIntEntry.set("status", (Object)"success");
        batchIntEntry.set("intcomment", (Object)String.format(ResManager.loadKDString((String)"%1$s\u6536\u606f%2$s", (String)"SuretySettleIntBatchAuditService_3", (String)"tmc-fbd-business", (Object[])new Object[0]), DateUtils.formatString((Date)batchIntEntry.getDate("enddate"), (String)"yyyy-MM-dd"), batchIntEntry.getDynamicObject("currency").getString("sign") + batchIntEntry.getBigDecimal("actualinstamt")));
    }

    private static void setTargetBillEntry(DynamicObject targetBill, String detailTagInfo) {
        IntBillInfo intBillInfo = (IntBillInfo)SerializationUtils.fromJsonString((String)detailTagInfo, IntBillInfo.class);
        DynamicObjectCollection entryCol = targetBill.getDynamicObjectCollection("entrys");
        entryCol.clear();
        List details = intBillInfo.getDetails();
        for (IntBillDetailInfo detailInfo : details) {
            DynamicObject newEntry = entryCol.addNew();
            newEntry.set("inststartdate", (Object)detailInfo.getBeginDate());
            newEntry.set("instenddate", (Object)detailInfo.getEndDate());
            newEntry.set("instdays", (Object)detailInfo.getDays());
            newEntry.set("instprincipalamt", (Object)detailInfo.getPrinciple());
            newEntry.set("rate", (Object)detailInfo.getRate());
            newEntry.set("ratetrandays", (Object)detailInfo.getBasisDay());
            newEntry.set("instamt", (Object)detailInfo.getAmount());
        }
    }
}

