/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.oppservice.suretystlint;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.tmc.fbd.common.enums.RevenueTypeEnum;
import kd.tmc.fbd.common.helper.SuretyIntCalcHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SuretySettleIntSubmitService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("sourcebillid");
        sic.add("revenuetype");
        sic.add("prestartdate");
        sic.add("prestenddate");
        sic.add("expiredate");
        sic.add("bizdate");
        sic.add("predictpreinstamt");
        sic.add("actpreinstamt");
        sic.add("entrys");
        sic.add("entrys.seq");
        sic.add("entrys.inststartdate");
        sic.add("entrys.instenddate");
        sic.add("entrys.instdays");
        sic.add("entrys.instprincipalamt");
        sic.add("entrys.rate");
        sic.add("entrys.ratetrandays");
        sic.add("entrys.instamt");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject dataEntity : dataEntities) {
            String revenueType = dataEntity.getString("revenuetype");
            if (!RevenueTypeEnum.REVENUE.getValue().equals(revenueType)) continue;
            this.createByNormalSubmit(dataEntity);
        }
    }

    private void createByNormalSubmit(DynamicObject dataEntity) {
        Date endDate;
        Date beginDate;
        IntBillInfo intBill;
        Long sourceId = dataEntity.getLong("sourcebillid");
        if (EmptyUtil.isNoEmpty((Long)sourceId) && (intBill = SuretyIntCalcHelper.callInt((Long)sourceId, (Date)(beginDate = dataEntity.getDate("prestartdate")), (Date)(endDate = dataEntity.getDate("bizdate")), (boolean)true)) != null) {
            dataEntity.set("predictpreinstamt", (Object)intBill.getAmount());
            DynamicObjectCollection entrys = dataEntity.getDynamicObjectCollection("entrys");
            if (EmptyUtil.isNoEmpty((Object)intBill.getDetails())) {
                SuretyIntCalcHelper.addDetail((DynamicObjectCollection)entrys, (List)intBill.getDetails());
            }
        }
    }
}

