/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.validate.currencypair;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class CurrencyPairSaveOpValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List list = super.getSelector();
        list.add("pid");
        list.add("quotecurrency");
        list.add("basiscurrency");
        return list;
    }

    public void validate(ExtendedDataEntity[] paramArrayOfExtendedDataEntity) throws KDBizException {
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            Long pid = bill.getLong("pid");
            String quoteCurrency = bill.getDynamicObject("quotecurrency").getString("number");
            String basisCurrency = bill.getDynamicObject("basiscurrency").getString("number");
            QFilter qFiltersPid = new QFilter("pid", "=", (Object)pid);
            qFiltersPid.and("id", "!=", (Object)bill.getLong("id"));
            QFilter qFiltersC = new QFilter("number", "=", (Object)(quoteCurrency + "/" + basisCurrency));
            qFiltersC.or("number", "=", (Object)(basisCurrency + "/" + quoteCurrency));
            boolean exists = TmcDataServiceHelper.exists((String)"tbd_currencypair", (QFilter[])new QFilter[]{qFiltersPid, qFiltersC});
            if (!exists) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"BILLNO_EXIST", (String)"tmc-fbd-business", (Object[])new Object[0]));
        }
    }
}

