/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.validate.entitymap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillRelationTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class EntityMapSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List list = super.getSelector();
        list.add("biztype");
        list.add("srcentity");
        list.add("tagentity");
        list.add("checkop");
        list.add("billrelationtype");
        list.add("matchsrcfieldval");
        list.add("matchtagfieldval");
        list.add("ishasentry");
        list.add("entryrelation");
        list.add("billrelationtype");
        list.add("entryentity");
        list.add("entryentity.proptype");
        list.add("entryentity.srcfield");
        list.add("entryentity.targetfield");
        list.add("srcattach");
        list.add("tagattach");
        list.add("allowentryentity");
        list.add("allowentryentity.fbtagfield");
        list.add("entryrelation.relationtype");
        list.add("entryrelation.entrysrcfieldval");
        list.add("entryrelation.entrytagfieldval");
        return list;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject info = dataEntity.getDataEntity();
            DynamicObject srcEntity = info.getDynamicObject("srcentity");
            DynamicObject tagEntity = info.getDynamicObject("tagentity");
            this.validateEntryField(dataEntity, info);
            this.validateCodeType(dataEntity, info, srcEntity, tagEntity);
            this.validateAllowFeild(dataEntity, info, tagEntity);
            this.validateCheckOp(dataEntity, info);
            this.validateDataIsHas(dataEntity, info, srcEntity, tagEntity);
        }
    }

    private void validateCheckOp(ExtendedDataEntity dataEntity, DynamicObject info) {
        String checkops = info.getString("checkop");
        Set opList = Arrays.stream(checkops.replaceFirst(",", "").split(",")).collect(Collectors.toSet());
        if (opList.contains("handedit") && opList.size() > 1) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u76ee\u6807\u5b9e\u4f53\u4e1a\u52a1\u64cd\u4f5c\u7684[\u81ea\u5b9a\u4e49\u7f16\u8f91]\u548c\u5176\u4ed6\u4e0b\u62c9\u9009\u9879\u4e0d\u80fd\u540c\u65f6\u5b58\u5728\u3002", (String)"EntityMapSaveValidator_22", (String)"tmc-fbd-business", (Object[])new Object[0]));
        }
    }

    private void validateEntryField(ExtendedDataEntity dataEntity, DynamicObject info) {
        String srcMatchFieldVal = info.getString("matchsrcfieldval");
        String tagMatchfieldval = info.getString("matchtagfieldval");
        String billRelationType = info.getString("billrelationtype");
        if (EmptyUtil.isEmpty((String)srcMatchFieldVal) || EmptyUtil.isEmpty((String)tagMatchfieldval)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6e90\u5b9e\u4f53\u548c\u76ee\u6807\u5b9e\u4f53\u5339\u914d\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a", (String)"EntityMapSaveValidator_01", (String)"tmc-fbd-business", (Object[])new Object[0]));
            return;
        }
        String[] srcMatchFieldArray = srcMatchFieldVal.split("\\.");
        String[] tagMatchFieldArray = tagMatchfieldval.split("\\.");
        List<String> headFieldList = Arrays.asList("id", "billno");
        ArrayList<String> srcEntryFieldList = new ArrayList<String>(10);
        ArrayList<String> tagEntryFieldList = new ArrayList<String>(10);
        if (BillRelationTypeEnum.isH2H_SID((String)billRelationType) || BillRelationTypeEnum.isH2H_TID((String)billRelationType)) {
            if (srcMatchFieldArray.length > 1 || tagMatchFieldArray.length > 1) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6e90\u5b9e\u4f53\u5339\u914d\u5c5e\u6027\u548c\u76ee\u6807\u5b9e\u4f53\u5339\u914d\u5c5e\u6027\u5fc5\u987b\u914d\u7f6e\u4e3a\u5355\u636e\u5934\u7684\u5c5e\u6027\u3002", (String)"EntityMapSaveValidator_02", (String)"tmc-fbd-business", (Object[])new Object[0]));
                return;
            }
            if (BillRelationTypeEnum.isH2H_SID((String)billRelationType) && !headFieldList.contains(srcMatchFieldArray[0])) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u5355\u636e\u5339\u914d\u7c7b\u578b\u4e3a\u76ee\u6807\u5b9e\u4f53\u5305\u542b\u6e90\u5b9e\u4f53\u5c5e\u6027(\u5355\u636e\u5934->\u5355\u636e\u5934)\u65f6,\u6e90\u5b9e\u4f53\u5339\u914d\u5c5e\u6027\u5fc5\u987b\u914d\u7f6e\u4e3a\u5355\u636e\u5934\u7684id\u6216\u8005billno\u5c5e\u6027\u3002", (String)"EntityMapSaveValidator_03", (String)"tmc-fbd-business", (Object[])new Object[0]));
                return;
            }
            if (BillRelationTypeEnum.isH2H_TID((String)billRelationType) && !headFieldList.contains(tagMatchFieldArray[0])) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u5355\u636e\u5339\u914d\u7c7b\u578b\u4e3a\u6e90\u5b9e\u4f53\u5305\u542b\u76ee\u6807\u5b9e\u4f53\u5c5e\u6027(\u5355\u636e\u5934->\u5355\u636e\u5934)\u65f6,\u76ee\u6807\u5b9e\u4f53\u5339\u914d\u5c5e\u6027\u5fc5\u987b\u914d\u7f6e\u4e3a\u5355\u636e\u5934\u7684id\u6216\u8005billno\u5c5e\u6027\u3002", (String)"EntityMapSaveValidator_04", (String)"tmc-fbd-business", (Object[])new Object[0]));
                return;
            }
        } else if (BillRelationTypeEnum.isH2E_SID((String)billRelationType)) {
            if (srcMatchFieldArray.length > 1 || tagMatchFieldArray.length <= 1) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u5355\u636e\u5339\u914d\u7c7b\u578b\u4e3a\u76ee\u6807\u5b9e\u4f53\u5305\u542b\u6e90\u5b9e\u4f53\u5c5e\u6027(\u5355\u636e\u5934->\u5206\u5f55)\u65f6,\u6e90\u5b9e\u4f53\u5339\u914d\u5c5e\u6027\u5fc5\u987b\u914d\u7f6e\u4e3a\u5355\u636e\u5934\u7684\u5c5e\u6027,\u76ee\u6807\u5b9e\u4f53\u5339\u914d\u5c5e\u6027\u5fc5\u987b\u914d\u7f6e\u4e3a\u5206\u5f55\u4e2d\u7684\u5c5e\u6027\u3002", (String)"EntityMapSaveValidator_05", (String)"tmc-fbd-business", (Object[])new Object[0]));
                return;
            }
            if (!headFieldList.contains(srcMatchFieldArray[0])) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u5355\u636e\u5339\u914d\u7c7b\u578b\u4e3a\u76ee\u6807\u5b9e\u4f53\u5305\u542b\u6e90\u5b9e\u4f53\u5c5e\u6027(\u5355\u636e\u5934->\u5206\u5f55)\u65f6,\u6e90\u5b9e\u4f53\u5339\u914d\u5c5e\u6027\u5fc5\u987b\u914d\u7f6e\u4e3a\u5355\u636e\u5934\u7684id\u6216\u8005billno\u5c5e\u6027\u3002", (String)"EntityMapSaveValidator_06", (String)"tmc-fbd-business", (Object[])new Object[0]));
                return;
            }
            tagEntryFieldList.add(tagMatchFieldArray[0]);
        } else if (BillRelationTypeEnum.isE2H_TID((String)billRelationType)) {
            if (srcMatchFieldArray.length <= 1 || tagMatchFieldArray.length > 1) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u5355\u636e\u5339\u914d\u7c7b\u578b\u4e3a\u6e90\u5b9e\u4f53\u5305\u542b\u76ee\u6807\u5b9e\u4f53\u5c5e\u6027(\u5206\u5f55->\u5355\u636e\u5934)\u65f6,\u6e90\u5b9e\u4f53\u5339\u914d\u5c5e\u6027\u5fc5\u987b\u914d\u7f6e\u4e3a\u5206\u5f55\u4e2d\u7684\u5c5e\u6027,\u76ee\u6807\u5b9e\u4f53\u5339\u914d\u5c5e\u6027\u5fc5\u987b\u914d\u7f6e\u4e3a\u5355\u636e\u5934\u7684\u5c5e\u6027\u3002", (String)"EntityMapSaveValidator_07", (String)"tmc-fbd-business", (Object[])new Object[0]));
                return;
            }
            if (!headFieldList.contains(tagMatchFieldArray[0])) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u5355\u636e\u5339\u914d\u7c7b\u578b\u4e3a\u6e90\u5b9e\u4f53\u5305\u542b\u76ee\u6807\u5b9e\u4f53\u5c5e\u6027(\u5206\u5f55->\u5355\u636e\u5934)\u65f6,\u76ee\u6807\u5b9e\u4f53\u5339\u914d\u5c5e\u6027\u5fc5\u987b\u914d\u7f6e\u4e3a\u5355\u636e\u5934\u7684id\u6216\u8005billno\u5c5e\u6027\u3002", (String)"EntityMapSaveValidator_08", (String)"tmc-fbd-business", (Object[])new Object[0]));
                return;
            }
            srcEntryFieldList.add(srcMatchFieldArray[0]);
        }
        DynamicObjectCollection entryRelation = info.getDynamicObjectCollection("entryrelation");
        HashSet<ThreeTuple> entryLinks = new HashSet<ThreeTuple>(10);
        if (info.getBoolean("ishasentry")) {
            for (DynamicObject entityMapInfo : entryRelation) {
                String entryTagFieldval;
                String entrySrcFieldval;
                String relationType = entityMapInfo.getString("relationtype");
                if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{relationType, entrySrcFieldval = entityMapInfo.getString("entrysrcfieldval"), entryTagFieldval = entityMapInfo.getString("entrytagfieldval")})) continue;
                entryLinks.add(new ThreeTuple((Object)relationType, (Object)entrySrcFieldval, (Object)entryTagFieldval));
                srcEntryFieldList.add(entrySrcFieldval.split("\\.")[0]);
                tagEntryFieldList.add(entryTagFieldval.split("\\.")[0]);
            }
        }
        if (new HashSet(srcEntryFieldList).size() != srcEntryFieldList.size()) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5206\u5f55\u95f4\u5339\u914d\u5173\u7cfb\u4e2d\u6e90\u5206\u5f55\u5339\u914d\u5c5e\u6027\u6709\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EntityMapSaveValidator_09", (String)"tmc-fbd-business", (Object[])new Object[0]), new Object[0]));
            return;
        }
        if (new HashSet(tagEntryFieldList).size() != tagEntryFieldList.size()) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5206\u5f55\u95f4\u5339\u914d\u5173\u7cfb\u4e2d\u76ee\u6807\u5206\u5f55\u5339\u914d\u5c5e\u6027\u6709\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EntityMapSaveValidator_10", (String)"tmc-fbd-business", (Object[])new Object[0]), new Object[0]));
            return;
        }
        DynamicObjectCollection entryEntitys = info.getDynamicObjectCollection("entryentity");
        ArrayList<String> tagValFieldList = new ArrayList<String>(10);
        for (int i = 0; i < entryEntitys.size(); ++i) {
            DynamicObject entryInfo = (DynamicObject)entryEntitys.get(i);
            if (EmptyUtil.isEmpty((DynamicObject)entryInfo)) continue;
            String srcField = entryInfo.getString("srcfield");
            String targetField = entryInfo.getString("targetfield");
            tagValFieldList.add(targetField);
            if (EmptyUtil.isEmpty((String)targetField) || EmptyUtil.isEmpty((String)srcField)) continue;
            String[] srcFieldArray = srcField.split("\\.");
            String[] targetFieldArray = targetField.split("\\.");
            if (srcMatchFieldArray.length > 1 && srcFieldArray.length > 1 && !srcFieldArray[0].equals(srcMatchFieldArray[0])) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1s\u884c\u7684\u5f53\u524d\u5b9e\u4f53\u5c5e\u6027\u7684\u5206\u5f55\u6807\u8bc6[%2s]\u4e0e\u5206\u5f55\u6620\u5c04\u914d\u7f6e\u4e2d\u7684\u5f53\u524d\u5206\u5f55\u5b9e\u4f53\u5c5e\u6027[%3s]\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EntityMapSaveValidator_11", (String)"tmc-fbd-business", (Object[])new Object[0]), i + 1, srcFieldArray[0], srcMatchFieldArray[0]));
                continue;
            }
            if (tagMatchFieldArray.length > 1 && targetFieldArray.length > 1 && !targetFieldArray[0].equals(tagMatchFieldArray[0])) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1s\u884c\u7684\u76ee\u6807\u5b9e\u4f53\u5c5e\u6027\u7684\u5206\u5f55\u6807\u8bc6[%2s]\u4e0e\u5206\u5f55\u6620\u5c04\u914d\u7f6e\u4e2d\u7684\u76ee\u6807\u5206\u5f55\u5b9e\u4f53\u5c5e\u6027[%3s]\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EntityMapSaveValidator_12", (String)"tmc-fbd-business", (Object[])new Object[0]), i + 1, targetFieldArray[0], tagMatchFieldArray[0]));
                continue;
            }
            if (srcFieldArray.length > 1 && targetFieldArray.length > 1) {
                if (entryLinks.size() <= 0) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1s\u884c\u7684\u6e90\u5b9e\u4f53\u5c5e\u6027\u548c\u76ee\u6807\u5b9e\u4f53\u5c5e\u6027\u90fd\u662f\u5206\u5f55\u5b57\u6bb5\u65f6\uff0c\u5fc5\u987b\u914d\u7f6e\u5206\u5f55\u95f4\u5339\u914d\u5173\u7cfb\u3002", (String)"EntityMapSaveValidator_13", (String)"tmc-fbd-business", (Object[])new Object[0]), i + 1, targetFieldArray[0], tagMatchFieldArray[0]));
                    continue;
                }
                Optional<ThreeTuple> entryMatchSetOl = entryLinks.stream().filter(o -> ((String)o.item2).split("\\.")[0].equals(srcFieldArray[0]) && ((String)o.item3).split("\\.")[0].equals(targetFieldArray[0])).findFirst();
                if (!entryMatchSetOl.isPresent()) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1s\u884c\u7684\u6e90\u5b9e\u4f53\u5c5e\u6027\u548c\u76ee\u6807\u5b9e\u4f53\u5c5e\u6027\u90fd\u662f\u5206\u5f55\u5b57\u6bb5\u65f6\uff0c\u5206\u5f55\u95f4\u5339\u914d\u5173\u7cfb\u5fc5\u987b\u5b58\u5728\u6e90\u5b9e\u4f53\u5206\u5f55\u548c\u76ee\u6807\u5b9e\u4f53\u5206\u5f55\u3002", (String)"EntityMapSaveValidator_14", (String)"tmc-fbd-business", (Object[])new Object[0]), i + 1, targetFieldArray[0], tagMatchFieldArray[0]));
                    continue;
                }
            }
            if (srcFieldArray.length > 1 && !srcEntryFieldList.contains(srcFieldArray[0])) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1s\u884c\u5c5e\u6027\u503c\u6620\u5c04\u914d\u7f6e\u7684\u6e90\u5b9e\u4f53\u5c5e\u6027\u4e3a\u5206\u5f55\u5b57\u6bb5\uff0c\u6ca1\u6709\u51fa\u73b0\u5728\u5355\u636e\u5339\u914d\u5173\u7cfb\u914d\u7f6e\u4e2d,\u4e0d\u80fd\u914d\u7f6e\u8be5\u5c5e\u6027\u3002", (String)"EntityMapSaveValidator_15", (String)"tmc-fbd-business", (Object[])new Object[0]), i + 1));
                continue;
            }
            if (targetFieldArray.length <= 1 || tagEntryFieldList.contains(targetFieldArray[0])) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1s\u884c\u5c5e\u6027\u503c\u6620\u5c04\u914d\u7f6e\u7684\u76ee\u6807\u5b9e\u4f53\u5c5e\u6027\u4e3a\u5206\u5f55\u5b57\u6bb5\uff0c\u6ca1\u6709\u51fa\u73b0\u5728\u5355\u636e\u5339\u914d\u5173\u7cfb\u914d\u7f6e\u4e2d,\u4e0d\u80fd\u914d\u7f6e\u8be5\u5c5e\u6027\u3002", (String)"EntityMapSaveValidator_16", (String)"tmc-fbd-business", (Object[])new Object[0]), i + 1));
        }
        if (new HashSet(tagValFieldList).size() != tagValFieldList.size()) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5c5e\u6027\u503c\u6620\u5c04\u914d\u7f6e(\u6838\u5fc3\u903b\u8f91)\u5206\u5f55\u4e2d\u76ee\u6807\u5b9e\u4f53\u5c5e\u6027\u6709\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EntityMapSaveValidator_23", (String)"tmc-fbd-business", (Object[])new Object[0]), new Object[0]));
        }
    }

    private void validateAllowFeild(ExtendedDataEntity dataEntity, DynamicObject info, DynamicObject tagEntity) {
        if (EmptyUtil.isEmpty((DynamicObject)tagEntity)) {
            return;
        }
        DynamicObjectCollection fbEntryEntity = info.getDynamicObjectCollection("allowentryentity");
        for (int i = 0; i < fbEntryEntity.size(); ++i) {
            String targetField;
            DynamicObject entryInfo = (DynamicObject)fbEntryEntity.get(i);
            if (EmptyUtil.isEmpty((DynamicObject)entryInfo) || EmptyUtil.isEmpty((String)(targetField = entryInfo.getString("fbtagfield")))) continue;
            String[] targetFieldArray = targetField.split("\\.");
            DataEntityPropertyCollection properties = EntityMetadataCache.getDataEntityType((String)tagEntity.getString("number")).getProperties();
            boolean isAmoutProp = false;
            if (targetFieldArray.length == 1) {
                IDataEntityProperty fieldProperty = (IDataEntityProperty)properties.get((Object)targetFieldArray[0]);
                isAmoutProp = fieldProperty instanceof AmountProp;
            } else {
                IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get((Object)targetFieldArray[0]);
                if (iDataEntityProperty instanceof EntryProp) {
                    DynamicObjectType entryPropType = ((EntryProp)iDataEntityProperty).getDynamicCollectionItemPropertyType();
                    DataEntityPropertyCollection entryPropertys = entryPropType.getProperties();
                    IDataEntityProperty entryProp = (IDataEntityProperty)entryPropertys.get((Object)targetFieldArray[1]);
                    isAmoutProp = entryProp instanceof AmountProp;
                }
            }
            if (!isAmoutProp) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u76ee\u6807\u5b9e\u4f53\u5141\u8bb8\u914d\u7f6e\u5c5e\u6027\u5206\u5f55\u7684\u7b2c%s\u884c\u4e3a\u91d1\u989d\u5b57\u6bb5,\u4e0d\u5141\u8bb8\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EntityMapSaveValidator_17", (String)"tmc-fbd-business", (Object[])new Object[0]), i + 1));
        }
    }

    private void validateDataIsHas(ExtendedDataEntity dataEntity, DynamicObject info, DynamicObject srcEntity, DynamicObject tagEntity) {
        if (EmptyUtil.isEmpty((DynamicObject)srcEntity) || EmptyUtil.isEmpty((DynamicObject)tagEntity)) {
            return;
        }
        if (tagEntity.getString("number").equals(srcEntity.getString("number"))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6e90\u5b9e\u4f53\u548c\u76ee\u6807\u5b9e\u4f53\u4e0d\u80fd\u4e00\u6837\u3002", (String)"EntityMapSaveValidator_24", (String)"tmc-fbd-business", (Object[])new Object[0]));
            return;
        }
        Long id = info.getLong("id");
        String bizType = info.getString("biztype");
        String tagEntityNumber = tagEntity.getString("number");
        QFilter qFilter = new QFilter("tagentity.number", "=", (Object)tagEntityNumber).and("id", "!=", (Object)id).and("biztype", "=", (Object)bizType).and("enable", "=", (Object)"1");
        if (QueryServiceHelper.exists((String)"fbd_entitymapmodel", (QFilter[])new QFilter[]{qFilter})) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5b9e\u4f53\u6620\u5c04\u6a21\u578b\u5b58\u5728\u5df2\u542f\u52a8\u7684\u8be5\u4e1a\u52a1\u573a\u666f\u76ee\u6807\u5b9e\u4f53\u4e3a%s\u7684\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u5b58\u5728,\u8bf7\u5148\u7981\u7528\u539f\u6765\u7684\u6570\u636e", (String)"EntityMapSaveValidator_18", (String)"tmc-fbd-business", (Object[])new Object[0]), tagEntityNumber));
        }
    }

    private void validateCodeType(ExtendedDataEntity dataEntity, DynamicObject info, DynamicObject srcEntity, DynamicObject tagEntity) {
        if (EmptyUtil.isEmpty((DynamicObject)srcEntity) || EmptyUtil.isEmpty((DynamicObject)tagEntity)) {
            return;
        }
        DynamicObjectCollection entryEntitys = info.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < entryEntitys.size(); ++i) {
            DynamicObject entryInfo = (DynamicObject)entryEntitys.get(i);
            if (EmptyUtil.isEmpty((DynamicObject)entryInfo)) continue;
            String propType = entryInfo.getString("proptype");
            List<String> volidPropTypes = Arrays.asList("all", "basedata");
            String srcField = entryInfo.getString("srcfield");
            String targetField = entryInfo.getString("targetfield");
            if (EmptyUtil.isEmpty((String)targetField) || EmptyUtil.isEmpty((String)srcField)) continue;
            String[] srcFieldArray = srcField.split("\\.");
            String[] targetFieldArray = targetField.split("\\.");
            Pair<String, String> srcFieldInfo = this.getCodeType(srcEntity, srcFieldArray);
            Pair<String, String> tagFieldInfo = this.getCodeType(tagEntity, targetFieldArray);
            if (!volidPropTypes.contains(propType) || srcFieldInfo == null || tagFieldInfo == null) continue;
            String srcKey = (String)srcFieldInfo.getKey();
            String srcVal = (String)srcFieldInfo.getValue();
            String tagKey = (String)tagFieldInfo.getKey();
            String tagVal = (String)tagFieldInfo.getValue();
            if (srcKey.equals(tagKey) && tagVal.equals(srcVal) || !srcKey.equals(tagKey) && ("long".equalsIgnoreCase(srcKey) || "long".equalsIgnoreCase(tagKey))) continue;
            if (!srcKey.equals(tagKey)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1s\u884c\u7684\u5f53\u524d\u5c5e\u6027\u7c7b\u578b\u4e3a%2s\u4e0e\u76ee\u6807\u5c5e\u6027\u7c7b\u578b%3s\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EntityMapSaveValidator_19", (String)"tmc-fbd-business", (Object[])new Object[0]), i + 1, srcKey, tagKey));
                continue;
            }
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1s\u884c\u7684\u5f53\u524d\u57fa\u7840\u8d44\u6599\u5b9e\u4f53\u7c7b\u578b\u4e3a%2s\u4e0e\u76ee\u6807\u57fa\u7840\u8d44\u6599\u5b9e\u4f53\u7c7b\u578b%3s\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EntityMapSaveValidator_20", (String)"tmc-fbd-business", (Object[])new Object[0]), i + 1, srcVal, tagVal));
        }
    }

    private Pair<String, String> getCodeType(DynamicObject entity, String[] fieldArray) {
        String entityNumber = entity.getString("number");
        if (StringUtils.isEmpty((CharSequence)entityNumber) || fieldArray == null || fieldArray.length == 0) {
            return null;
        }
        DataEntityPropertyCollection properties = EntityMetadataCache.getDataEntityType((String)entityNumber).getProperties();
        if (fieldArray.length == 1) {
            IDataEntityProperty fieldProperty = (IDataEntityProperty)properties.get((Object)fieldArray[0]);
            return EntityMapSaveValidator.getFieldInfoPair(fieldProperty);
        }
        IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get((Object)fieldArray[0]);
        if (iDataEntityProperty instanceof EntryProp) {
            DynamicObjectType entryPropType = ((EntryProp)iDataEntityProperty).getDynamicCollectionItemPropertyType();
            DataEntityPropertyCollection entryPropertys = entryPropType.getProperties();
            IDataEntityProperty entryProp = (IDataEntityProperty)entryPropertys.get((Object)fieldArray[1]);
            return EntityMapSaveValidator.getFieldInfoPair(entryProp);
        }
        return null;
    }

    private static Pair<String, String> getFieldInfoPair(IDataEntityProperty fieldProperty) {
        if (fieldProperty == null) {
            return null;
        }
        Class propertyType = fieldProperty.getPropertyType();
        if (EmptyUtil.isNoEmpty((Object)propertyType)) {
            String simpleName = propertyType.getSimpleName();
            String baseEntityId = "";
            if ("DynamicObject".equals(simpleName)) {
                if (fieldProperty instanceof MulBasedataProp) {
                    baseEntityId = ((MulBasedataProp)fieldProperty).getBaseEntityId();
                } else if (fieldProperty instanceof BasedataProp) {
                    baseEntityId = ((BasedataProp)fieldProperty).getBaseEntityId();
                }
            } else if ("ILocaleString".equals(simpleName)) {
                simpleName = "String";
            }
            return Pair.of((Object)simpleName, (Object)baseEntityId);
        }
        String errorInfo = String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u914d\u7f6e\u8be5\u5c5e\u6027%s\u3002", (String)"EntityMapSaveValidator_21", (String)"tmc-fbd-business", (Object[])new Object[0]), fieldProperty.getName());
        throw new KDBizException(errorInfo);
    }
}

