/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.validate.foreignmarketrate;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;

public class ForeignMarketRateSaveValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dt : dataEntities) {
            DynamicObject foreignMarketRate = dt.getDataEntity();
            Long id = (Long)foreignMarketRate.get("id");
            Long rateSources = foreignMarketRate.getLong("ratesources.id");
            Long originalCurrency = foreignMarketRate.getLong("originalcurrency.id");
            String targetCurrencyAmount = (String)foreignMarketRate.get("targetcurrencyamount");
            Long targetCurrency = foreignMarketRate.getLong("targetcurrency.id");
            Date releaseDate = foreignMarketRate.getDate("releasedate");
            DynamicObject deadlineObj = (DynamicObject)foreignMarketRate.get("deadline");
            BigDecimal buyBigDecimal = foreignMarketRate.getBigDecimal("buyingprice");
            BigDecimal sellBigDecimal = foreignMarketRate.getBigDecimal("sellingprice");
            if (buyBigDecimal.compareTo(BigDecimal.ZERO) == 0 && sellBigDecimal.compareTo(BigDecimal.ZERO) == 0) {
                this.addErrorMessage(dt, ResManager.loadKDString((String)"\u4e70\u5165\u4ef7\u548c\u5356\u51fa\u4ef7\u4e0d\u80fd\u90fd\u4e3a\u7a7a\u3002", (String)"ForeignMarketRateSaveValidator_1", (String)"tmc-fbd-business", (Object[])new Object[0]));
            }
            if (originalCurrency.equals(targetCurrency)) {
                this.addErrorMessage(dt, ResManager.loadKDString((String)"\u539f\u5e01\u548c\u76ee\u6807\u5e01\u4e0d\u80fd\u4e00\u6837\u3002", (String)"ForeignMarketRateSaveValidator_2", (String)"tmc-fbd-business", (Object[])new Object[0]));
            }
            QFilter returnIdFilter = new QFilter("originalcurrency", "=", (Object)originalCurrency).or(new QFilter("originalcurrency", "=", (Object)targetCurrency));
            returnIdFilter.and(new QFilter("ratesources", "=", (Object)rateSources));
            returnIdFilter.and(new QFilter("targetcurrency", "=", (Object)targetCurrency).or(new QFilter("targetcurrency", "=", (Object)originalCurrency)));
            returnIdFilter.and(new QFilter("targetcurrencyamount", "=", (Object)targetCurrencyAmount));
            returnIdFilter.and(new QFilter("releasedate", "=", (Object)releaseDate));
            returnIdFilter.and(new QFilter("deadline", "=", deadlineObj.getPkValue()));
            DynamicObjectCollection queryForeRateColl = QueryServiceHelper.query((String)"fbd_foreignmarkerate", (String)"id,name,number,ratesources,ratesources.name,originalcurrency.name,originalcurrency,targetcurrency,targetcurrencyamount", (QFilter[])new QFilter[]{returnIdFilter});
            if (queryForeRateColl == null || queryForeRateColl.size() == 0 || queryForeRateColl.size() <= 0 || id.equals(((DynamicObject)queryForeRateColl.get(0)).getLong("id"))) continue;
            this.addErrorMessage(dt, ResManager.loadKDString((String)"\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u671f\u9650\u7684\u5916\u6c47\u5e02\u573a\u724c\u4ef7\uff0c\u4e0d\u80fd\u8fdb\u884c\u65b0\u589e\u64cd\u4f5c\u3002", (String)"ForeignMarketRateSaveValidator_0", (String)"tmc-fbd-business", (Object[])new Object[0]));
        }
    }
}

