/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.validate.investmodel;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.tmc.fbd.common.enums.CurrencyRuleEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.RateResetEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InvestModelSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List list = super.getSelector();
        list.add("currencyrule");
        list.add("currency");
        list.add("ratetype");
        list.add("rateadjustmethod");
        list.add("rateresetdays");
        list.add("profittype");
        list.add("basis");
        list.add("intheadtailrule");
        list.add("intcalmethod");
        list.add("introundrule");
        list.add("effectrule");
        return list;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            boolean isRef;
            DynamicObject data = dataEntity.getDataEntity();
            if (EmptyUtil.isNoEmpty((Object)data.getPkValue()) && 0L != (Long)data.getPkValue() && (isRef = BaseDataRefrenceHelper.isRefrenced((String)"cim_investmodel", (Object)data.getPkValue()))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6a21\u578b\u5df2\u7ecf\u88ab\u5f15\u7528\uff0c\u4e0d\u80fd\u91cd\u590d\u5bfc\u5165\u3002", (String)"InvestModelSaveValidator_0", (String)"tmc-fbd-business", (Object[])new Object[0]));
            }
            String rule = data.getString("currencyrule");
            DynamicObjectCollection currencyList = data.getDynamicObjectCollection("currency");
            if (CurrencyRuleEnum.ASSIGNCURRENCY.getValue().equals(rule) && EmptyUtil.isEmpty((DynamicObjectCollection)currencyList)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u3010\u5e01\u79cd\u89c4\u5219\u3011\u4e3a\u6307\u5b9a\u5e01\u79cd\u65f6\uff0c\u3010\u6307\u5b9a\u5e01\u79cd\u3011\u5b57\u6bb5\u5fc5\u586b\u3002", (String)"InvestModelSaveValidator_1", (String)"tmc-fbd-business", (Object[])new Object[0]));
            }
            String rateType = data.getString("ratetype");
            String adjustMethod = data.getString("rateadjustmethod");
            int days = data.getInt("rateresetdays");
            if (days > 0 && !InterestTypeEnum.FLOAT.getValue().equals(rateType) && !RateResetEnum.noadjust.getValue().equals(adjustMethod)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u3010\u5229\u7387\u7c7b\u578b\u3011\u4e3a\u6d6e\u52a8\u5229\u7387\u5e76\u4e14\u3010\u5229\u7387\u91cd\u7f6e\u65b9\u5f0f\u3011\u4e3a\u5468\u671f\u6027\u91cd\u7f6e\u65f6\uff0c\u3010\u5229\u7387\u91cd\u7f6e\u504f\u79fb\uff08d\uff09\u3011\u8f93\u5165\u503c\u624d\u80fd\u5927\u4e8e0\uff0c\u8bf7\u4fee\u6539\u3002", (String)"InvestModelSaveValidator_2", (String)"tmc-fbd-business", (Object[])new Object[0]));
            }
            String profitType = data.getString("profittype");
            String profitWay = data.getString("profitway");
            if ("share".equals(profitType) && !"fixedfrequency".equals(profitWay)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u3010\u6536\u76ca\u7c7b\u578b\u3011\u4e3a\u4efd\u989d\u6536\u76ca\u65f6\uff0c\u3010\u6536\u76ca\u65b9\u5f0f\u3011\u9ed8\u8ba4\u662f\u4e3a\u56fa\u5b9a\u9891\u7387\u6536\u76ca\u3002", (String)"InvestModelSaveValidator_3", (String)"tmc-fbd-business", (Object[])new Object[0]));
            }
            String basis = data.getString("basis");
            if ("cash".equals(profitType) && EmptyUtil.isEmpty((String)basis)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u3010\u6536\u76ca\u7c7b\u578b\u3011\u4e3a\u73b0\u91d1\u6536\u76ca\u65f6\uff0c\u3010\u8ba1\u606f\u57fa\u51c6\u3011\u5b57\u6bb5\u5fc5\u586b\u3002", (String)"InvestModelSaveValidator_4", (String)"tmc-fbd-business", (Object[])new Object[0]));
            }
            String headTailRule = data.getString("intheadtailrule");
            if ("cash".equals(profitType) && EmptyUtil.isEmpty((String)headTailRule)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u3010\u6536\u76ca\u7c7b\u578b\u3011\u4e3a\u73b0\u91d1\u6536\u76ca\u65f6\uff0c\u3010\u8ba1\u606f\u5934\u5c3e\u89c4\u5219\u3011\u5b57\u6bb5\u5fc5\u586b\u3002", (String)"InvestModelSaveValidator_5", (String)"tmc-fbd-business", (Object[])new Object[0]));
            }
            String calMethod = data.getString("intcalmethod");
            if ("cash".equals(profitType) && EmptyUtil.isEmpty((String)calMethod)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u3010\u6536\u76ca\u7c7b\u578b\u3011\u4e3a\u73b0\u91d1\u6536\u76ca\u65f6\uff0c\u3010\u5229\u606f\u8ba1\u7b97\u65b9\u6cd5\u3011\u5b57\u6bb5\u5fc5\u586b\u3002", (String)"InvestModelSaveValidator_6", (String)"tmc-fbd-business", (Object[])new Object[0]));
            }
            String roundRule = data.getString("introundrule");
            if ("cash".equals(profitType) && EmptyUtil.isEmpty((String)roundRule)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u3010\u6536\u76ca\u7c7b\u578b\u3011\u4e3a\u73b0\u91d1\u6536\u76ca\u65f6\uff0c\u3010\u8ba1\u606f\u820d\u5165\u89c4\u5219\u3011\u5b57\u6bb5\u5fc5\u586b\u3002", (String)"InvestModelSaveValidator_7", (String)"tmc-fbd-business", (Object[])new Object[0]));
            }
            String effectRule = data.getString("effectrule");
            if ("cash".equals(profitType) && EmptyUtil.isEmpty((String)effectRule)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u3010\u6536\u76ca\u7c7b\u578b\u3011\u4e3a\u73b0\u91d1\u6536\u76ca\u65f6\uff0c\u3010\u6536\u76ca\u751f\u6548\u89c4\u5219\u3011\u5b57\u6bb5\u5fc5\u586b\u3002", (String)"InvestModelSaveValidator_8", (String)"tmc-fbd-business", (Object[])new Object[0]));
            }
            if ("cash".equals(profitType) && EmptyUtil.isEmpty((String)rateType)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u3010\u6536\u76ca\u7c7b\u578b\u3011\u4e3a\u73b0\u91d1\u6536\u76ca\u65f6\uff0c\u3010\u5229\u7387\u7c7b\u578b\u3011\u5b57\u6bb5\u5fc5\u586b\u3002", (String)"InvestModelSaveValidator_9", (String)"tmc-fbd-business", (Object[])new Object[0]));
            }
            if (!"cash".equals(profitType) || !InterestTypeEnum.FLOAT.getValue().equals(rateType) || !EmptyUtil.isEmpty((String)adjustMethod)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u3010\u6536\u76ca\u7c7b\u578b\u3011\u4e3a\u73b0\u91d1\u6536\u76ca\u4e14\u3010\u5229\u7387\u7c7b\u578b\u3011\u4e3a\u6d6e\u52a8\u5229\u7387\u65f6\uff0c\u3010\u5229\u7387\u91cd\u7f6e\u65b9\u5f0f\u3011\u5b57\u6bb5\u5fc5\u586b\u3002", (String)"InvestModelSaveValidator_10", (String)"tmc-fbd-business", (Object[])new Object[0]));
        }
    }
}

