/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.validate.ratederivative;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.RateTermEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RateDericativeSaveValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        String pattern = "^(\\d+)-(\\d+)$";
        Pattern r = Pattern.compile(pattern);
        block10: for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            String type;
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            switch (type = dataEntity.getString("type")) {
                case "forward": {
                    String FRA = dataEntity.getString("fra");
                    if (EmptyUtil.isEmpty((String)FRA)) {
                        this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201cFRA\u201d\u3002", (String)"RateDericativeSaveValidator_3", (String)"tmc-fbd-business", (Object[])new Object[0]));
                        continue block10;
                    }
                    Matcher matcher = r.matcher(FRA);
                    if (matcher.find()) {
                        DynamicObject referRate;
                        String rateTerm;
                        int T;
                        int M;
                        int N = Integer.parseInt(matcher.group(1));
                        if (N >= (M = Integer.parseInt(matcher.group(2)))) {
                            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"FRA\u540e\u9762\u7684\u6570\u503c\u9700\u8981\u5927\u4e8e\u524d\u9762\u7684\u6570\u503c\u3002", (String)"RateDericativeSaveValidator_1", (String)"tmc-fbd-business", (Object[])new Object[0]));
                        }
                        if ((T = (rateTerm = RateTermEnum.getName((String)(referRate = dataEntity.getDynamicObject("referrate")).getString("term"))).contains("y") ? Integer.parseInt(rateTerm.replace("y", "")) * 12 : Integer.parseInt(rateTerm.replace("m", ""))) == M - N) continue block10;
                        this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5229\u7387\u8fdc\u671f\u7684\u671f\u9650\u9700\u4e0e\u53c2\u8003\u5229\u7387\u7684\u671f\u9650\u4fdd\u6301\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"RateDericativeSaveValidator_2", (String)"tmc-fbd-business", (Object[])new Object[0]));
                        continue block10;
                    }
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"FRA\u7684\u6570\u636e\u9700\u6ee1\u8db3i-j\u7684\u683c\u5f0f\u3002", (String)"RateDericativeSaveValidator_0", (String)"tmc-fbd-business", (Object[])new Object[0]));
                    continue block10;
                }
                case "futures": {
                    String contract = dataEntity.getString("contract");
                    if (!EmptyUtil.isEmpty((String)contract)) continue block10;
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5408\u7ea6\u201d\u3002", (String)"RateDericativeSaveValidator_4", (String)"tmc-fbd-business", (Object[])new Object[0]));
                    continue block10;
                }
                case "swap": {
                    String term = dataEntity.getString("term");
                    if (!EmptyUtil.isEmpty((String)term)) continue block10;
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u671f\u9650\u201d\u3002", (String)"RateDericativeSaveValidator_5", (String)"tmc-fbd-business", (Object[])new Object[0]));
                }
            }
        }
    }
}

