/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.validate.referdata;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ReferDataBatchSaveValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] ExtendedDataEntities) throws KDBizException {
        HashMap<String, DynamicObject> dataMap = new HashMap<String, DynamicObject>(16);
        ArrayList referRateIds = new ArrayList(16);
        for (ExtendedDataEntity ExtendedDataEntity2 : ExtendedDataEntities) {
            DynamicObjectCollection entrys = ExtendedDataEntity2.getDataEntity().getDynamicObjectCollection("entryentity");
            referRateIds.addAll(entrys.stream().map(row -> row.getDynamicObject("referrate")).filter(EmptyUtil::isNoEmpty).map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        }
        if (!CollectionUtils.isEmpty(referRateIds)) {
            DynamicObject[] dataRates;
            DynamicObject[] dynamicObjectArray = dataRates = BusinessDataServiceHelper.load((String)"md_datarate", (String)"bizdate,referrate", (QFilter[])new QFilter[]{new QFilter("referrate", "in", referRateIds)});
            int n = dynamicObjectArray.length;
            for (int ExtendedDataEntity2 = 0; ExtendedDataEntity2 < n; ++ExtendedDataEntity2) {
                DynamicObject dataRate = dynamicObjectArray[ExtendedDataEntity2];
                Date bizDate = DateUtils.getDataFormat((Date)dataRate.getDate("bizdate"), (boolean)true);
                Object pkValue = dataRate.getDynamicObject("referrate").getPkValue();
                dataMap.put(bizDate.toString() + pkValue.toString(), dataRate);
            }
        }
        for (ExtendedDataEntity extendedDataEntity : ExtendedDataEntities) {
            DynamicObjectCollection entryEntities = extendedDataEntity.getDataEntity().getDynamicObjectCollection("entryentity");
            if (entryEntities.size() == 0) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u7ef4\u62a4\u53c2\u8003\u5229\u7387\u6570\u636e\u4fe1\u606f\u3002", (String)"ReferRateSaveOppValidator_0", (String)"tmc-fbd-business", (Object[])new Object[0]));
                break;
            }
            HashSet<String> rateSet = new HashSet<String>(entryEntities.size());
            for (DynamicObject entryEntity : entryEntities) {
                DynamicObject referRate = entryEntity.getDynamicObject("referrate");
                Date bizDate = entryEntity.getDate("bizdate");
                BigDecimal endPrice = entryEntity.getBigDecimal("endprice");
                if (EmptyUtil.isEmpty((DynamicObject)referRate)) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u53c2\u8003\u5229\u7387\u7f16\u7801\u3002", (String)"ReferRateSaveOppValidator_1", (String)"tmc-fbd-business", (Object[])new Object[0]));
                }
                if (EmptyUtil.isEmpty((Object)bizDate)) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u62a5\u4ef7\u65e5\u671f\u3002", (String)"ReferRateSaveOppValidator_2", (String)"tmc-fbd-business", (Object[])new Object[0]));
                }
                if (EmptyUtil.isEmpty((BigDecimal)endPrice)) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5229\u7387\u503c\u3002", (String)"ReferRateSaveOppValidator_3", (String)"tmc-fbd-business", (Object[])new Object[0]));
                }
                if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{referRate, bizDate, endPrice})) continue;
                StringBuilder numberDate = new StringBuilder();
                numberDate.append(referRate.getString("number")).append(bizDate);
                boolean isContain = rateSet.contains(numberDate.toString());
                if (isContain) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53c2\u8003\u5229\u7387\u7f16\u7801\u548c\u62a5\u4ef7\u65f6\u95f4\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ReferRateSaveOppValidator_5", (String)"tmc-fbd-business", (Object[])new Object[0]));
                } else {
                    rateSet.add(numberDate.toString());
                }
                if (!EmptyUtil.isNoEmpty(dataMap.get(DateUtils.getDataFormat((Date)bizDate, (boolean)true) + referRate.getPkValue().toString()))) continue;
                this.addWarningMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff1a%2$s\u4e0b\u6570\u636e\u503c\u5df2\u5b58\u5728\uff0c\u662f\u5426\u8986\u76d6\u539f\u6709\u6570\u636e\u3002", (String)"ReferRateSaveOppValidator_6", (String)"tmc-fbd-business", (Object[])new Object[0]), referRate.getString("number"), DateUtils.formatString((Date)bizDate, (String)"yyyy-MM-dd")));
            }
        }
    }
}

