/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.validate.referrate;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ReferRateBatchSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("entry");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject batchReferData = extendedDataEntity.getDataEntity();
            DynamicObjectCollection entry = batchReferData.getDynamicObjectCollection("entry");
            if (entry.size() == 0) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u5b9a\u4e49\u53c2\u8003\u5229\u7387\u671f\u9650\u3002", (String)"ReferRateBatchSaveValidator_1", (String)"tmc-fbd-business", (Object[])new Object[0]));
            }
            if (entry.stream().anyMatch(r -> EmptyUtil.isEmpty((String)r.getString("number")))) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u53c2\u8003\u5229\u7387\u7f16\u7801\u3002", (String)"ReferRateBatchSaveValidator_3", (String)"tmc-fbd-business", (Object[])new Object[0]));
            }
            Map<String, List<DynamicObject>> group = entry.stream().collect(Collectors.groupingBy(v -> v.getString("number")));
            ArrayList<String> repeatNumbers = new ArrayList<String>(16);
            for (Map.Entry<String, List<DynamicObject>> entrySet : group.entrySet()) {
                if (entrySet.getValue().size() <= 1) continue;
                repeatNumbers.add(entrySet.getKey());
            }
            if (repeatNumbers.size() <= 0) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53c2\u8003\u5229\u7387\u7f16\u7801\u4e0d\u80fd\u91cd\u590d\u3002", (String)"ReferRateBatchSaveValidator_2", (String)"tmc-fbd-business", (Object[])new Object[0]));
        }
    }
}

