/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.validate.settleconfig;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class SettleConfigSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List list = super.getSelector();
        list.add("org");
        list.add("counterparty");
        list.add("currencycol");
        return list;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject info = extendedDataEntity.getDataEntity();
            DynamicObject org = info.getDynamicObject("org");
            DynamicObject cp = info.getDynamicObject("counterparty");
            DynamicObjectCollection currencyCol = info.getDynamicObjectCollection("currencycol");
            for (DynamicObject currency : currencyCol) {
                QFilter filter = new QFilter("id", "!=", (Object)info.getLong("id"));
                filter.and(new QFilter("org.id", "=", (Object)org.getLong("id")));
                filter.and(new QFilter("counterparty.id", "=", (Object)cp.getLong("id")));
                filter.and(new QFilter("currencycol.fbasedataid", "=", (Object)currency.getLong("fbasedataid_id")));
                if (!TmcDataServiceHelper.exists((String)"tbd_settleconfig", (QFilter[])new QFilter[]{filter})) continue;
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4ea4\u6613\u4e3b\u4f53\u201c{%1$s}\u201d\u5bf9\u4ea4\u6613\u5bf9\u624b\u201c{%2$s}\u201d\u548c\u5e01\u79cd\u201c{%3$s}\u201d\u7684\u914d\u7f6e\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SettleConfigSaveValidator_0", (String)"tmc-fbd-business", (Object[])new Object[]{org.getString("name"), cp.getString("number"), currency.getDynamicObject("fbasedataid").getString("name")}));
            }
        }
    }
}

