/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.validate.subscribe;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class UserSubscribeSaveValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject data = dataEntity.getDataEntity();
            String fiterStr = data.getString("filter_tag");
            Map<String, String> conditionMap = this.getConditionSet(fiterStr);
            DynamicObject subTpl = TmcDataServiceHelper.loadSingleFromCache((Object)data.getDynamicObject("subscribetpl").getPkValue(), (String)"fbd_subscribetpl");
            Map<String, String> tplConditionMap = this.getConditionSet(subTpl.getString("filter_tag"));
            DynamicObject dataSource = data.getDynamicObject("datasource");
            Map<String, LocaleString> propertyNames = this.getPropertys(dataSource.getString("number"), tplConditionMap.keySet());
            StringBuilder cloumStr = new StringBuilder(16);
            StringBuilder compareStr = new StringBuilder(16);
            StringBuilder noNullStr = new StringBuilder(16);
            for (Map.Entry<String, String> map : tplConditionMap.entrySet()) {
                String con = map.getKey();
                if (!conditionMap.containsKey(con)) {
                    cloumStr.append(propertyNames.get(con)).append("\u3001");
                    continue;
                }
                String cq = conditionMap.get(con);
                String tplCq = map.getValue();
                String colunm = con;
                if (colunm.contains(".")) {
                    colunm = colunm.substring(0, con.indexOf("."));
                }
                if (CompareTypeEnum.ISNOTNULL.getId().equals(tplCq)) {
                    if (!CompareTypeEnum.ISNULL.getId().equals(cq)) continue;
                    noNullStr.append(propertyNames.get(colunm)).append("\u3001");
                    continue;
                }
                if (map.getValue().equals(conditionMap.get(con))) continue;
                compareStr.append(propertyNames.get(colunm)).append("\u3001");
            }
            if (cloumStr.length() > 0) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u53ef\u53d8\u6761\u4ef6\u4e2d\u5fc5\u987b\u5305\u542b\u5b57\u6bb5\u201c%s\u201d\uff0c\u8bf7\u6dfb\u52a0\u3002", (String)"UserSubscribeSaveValidator_0", (String)"tmc-fbd-business", (Object[])new Object[0]), cloumStr.substring(0, cloumStr.length() - 1)));
            }
            if (noNullStr.length() > 0) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u53ef\u53d8\u6761\u4ef6\u4e2d\u5b57\u6bb5\u201c%s\u201d\u7684\u6761\u4ef6\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u3002", (String)"UserSubscribeSaveValidator_1", (String)"tmc-fbd-business", (Object[])new Object[0]), noNullStr.substring(0, noNullStr.length() - 1)));
            }
            if (compareStr.length() <= 0) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u53ef\u53d8\u6761\u4ef6\u4e2d\u5b57\u6bb5\u201c%s\u201d\u7684\u6761\u4ef6\u503c\u548c\u8ba2\u9605\u6a21\u677f\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"UserSubscribeSaveValidator_2", (String)"tmc-fbd-business", (Object[])new Object[0]), compareStr.substring(0, compareStr.length() - 1)));
        }
    }

    private Map<String, String> getConditionSet(String fiterStr) {
        FilterCondition filterCon = (FilterCondition)SerializationUtils.fromJsonString((String)fiterStr, FilterCondition.class);
        List filterRows = filterCon.getFilterRow();
        HashMap<String, String> fieldMap = new HashMap<String, String>(filterRows.size());
        for (SimpleFilterRow filterRow : filterRows) {
            fieldMap.put(filterRow.getFieldName(), filterRow.getCompareType());
        }
        return fieldMap;
    }

    private Map<String, LocaleString> getPropertys(String entryName, Set<String> fields) {
        HashMap<String, LocaleString> fieldMaps = new HashMap<String, LocaleString>(fields.size());
        DynamicObject obj = TmcDataServiceHelper.newDynamicObject((String)entryName);
        DataEntityPropertyCollection properties = obj.getDataEntityType().getProperties();
        for (String field : fields) {
            if (field.contains(".")) {
                field = field.substring(0, field.indexOf("."));
            }
            fieldMaps.put(field, ((IDataEntityProperty)properties.get((Object)field)).getDisplayName());
        }
        return fieldMaps;
    }
}

