/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.validate.surety;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbd.common.enums.BillStatusEnum;
import kd.tmc.fbd.common.enums.RevenueWayEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SuretyBillSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("bizdate");
        selector.add("expiredate");
        selector.add("interesttype");
        selector.add("revenueway");
        selector.add("revenueplan");
        selector.add("interestrate");
        selector.add("referencerate");
        selector.add("basis");
        selector.add("demandrate");
        selector.add("amount");
        selector.add("entry_credit");
        selector.add("org");
        selector.add("currency");
        selector.add("settleaccount");
        selector.add("finaccount");
        selector.add("surplusamount");
        selector.add(String.join((CharSequence)".", "entry_creditcreditbillidisclose"));
        selector.add("entry");
        selector.add("entry.suretyamount");
        selector.add("entry.creditamount");
        selector.add("entry.debtbillno");
        selector.add("entry.debttype");
        selector.add("entry.debtbillid");
        selector.add("entry.debtcurrency");
        selector.add("entry.creditcurrency");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendData : dataEntity) {
            List creditNotClose;
            DynamicObject suretyBill = extendData.getDataEntity();
            this.checkMustInputByInterestType(extendData, suretyBill);
            DynamicObjectCollection entries = suretyBill.getDynamicObjectCollection("entry");
            DynamicObject org = suretyBill.getDynamicObject("org");
            DynamicObject currency = suretyBill.getDynamicObject("currency");
            Date bizDate = suretyBill.getDate("bizdate");
            BigDecimal totalSuretyAmt = Constants.ZERO;
            HashSet<String> debtBillNos = new HashSet<String>(10);
            for (DynamicObject entry : entries) {
                QFilter relateSuretyFilter = new QFilter("billstatus", "in", Arrays.asList(BillStatusEnum.SUBMIT.getValue(), BillStatusEnum.AUDIT.getValue())).and("entry.debtbillid", "=", (Object)entry.getLong("debtbillid")).and("entry.debttype", "=", (Object)entry.getString("debttype"));
                if (QueryServiceHelper.exists((String)"fbd_suretybill", (QFilter[])new QFilter[]{relateSuretyFilter})) {
                    debtBillNos.add(entry.getString("debtbillno"));
                }
                DynamicObject debtCurrency = entry.getDynamicObject("debtcurrency");
                BigDecimal suretyAmount = entry.getBigDecimal("suretyamount");
                if (EmptyUtil.isEmpty((DynamicObject)debtCurrency) || EmptyUtil.isEmpty((BigDecimal)suretyAmount)) continue;
                BigDecimal exchangeRate = this.getRate(debtCurrency.getLong("id"), currency.getLong("id"), org.getLong("id"), bizDate);
                totalSuretyAmt = totalSuretyAmt.add(suretyAmount.multiply(exchangeRate).setScale(currency.getInt("amtprecision"), RoundingMode.HALF_UP));
            }
            if (!debtBillNos.isEmpty()) {
                this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u503a\u52a1\u5355\u636e%s\u5df2\u5173\u8054\u4fdd\u8bc1\u91d1\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u5173\u8054\uff0c\u8bf7\u4fee\u6539\u3002", (String)"SuretyBillSubmitValidator_14", (String)"tmc-fbd-business", (Object[])new Object[]{String.join((CharSequence)",", debtBillNos)}));
            }
            if (suretyBill.getBigDecimal("surplusamount").compareTo(totalSuretyAmt) < 0) {
                this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u503a\u52a1\u5360\u7528\u4fdd\u8bc1\u91d1\u91d1\u989d\u5408\u8ba1\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u5269\u4f59\u91d1\u989d\u3002", (String)"SuretyBillSubmitValidator_10", (String)"tmc-fbd-business", (Object[])new Object[0]));
            }
            if (RevenueWayEnum.STAGE.getValue().equals(suretyBill.getString("revenueway"))) {
                if (EmptyUtil.isEmpty((String)suretyBill.getString("interesttype"))) {
                    this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u5f53\u6536\u76ca\u65b9\u5f0f\u4e3a\u56fa\u5b9a\u9891\u7387\u6536\u76ca\u65f6,\u5229\u7387\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SuretyBillSubmitValidator_6", (String)"tmc-fbd-business", (Object[])new Object[0]));
                }
                if (EmptyUtil.isEmpty((String)suretyBill.getString("revenueplan"))) {
                    this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u5f53\u6536\u76ca\u65b9\u5f0f\u4e3a\u56fa\u5b9a\u9891\u7387\u6536\u76ca\u65f6,\u6536\u76ca\u65b9\u6848\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SuretyBillSubmitValidator_1", (String)"tmc-fbd-business", (Object[])new Object[0]));
                }
                if (EmptyUtil.isEmpty((String)suretyBill.getString("basis"))) {
                    this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u5f53\u6536\u76ca\u65b9\u5f0f\u4e3a\u56fa\u5b9a\u9891\u7387\u6536\u76ca\u65f6,\u8ba1\u606f\u57fa\u51c6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SuretyBillSubmitValidator_7", (String)"tmc-fbd-business", (Object[])new Object[0]));
                }
            }
            DynamicObjectCollection creditEntry = suretyBill.getDynamicObjectCollection("entry_credit");
            DynamicObject investVarieties = suretyBill.getDynamicObject("investvarieties");
            if (EmptyUtil.isNoEmpty((DynamicObject)investVarieties) && !investVarieties.getBoolean("islimitsurety") && EmptyUtil.isNoEmpty((DynamicObjectCollection)creditEntry)) {
                this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u975e\u989d\u5ea6\u4fdd\u8bc1\u91d1\u4e0d\u80fd\u5173\u8054\u6388\u4fe1\u3002", (String)"SuretyBillSubmitValidator_8", (String)"tmc-fbd-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)investVarieties) && investVarieties.getBoolean("islimitsurety") && EmptyUtil.isNoEmpty((DynamicObjectCollection)suretyBill.getDynamicObjectCollection("entry"))) {
                this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u989d\u5ea6\u4fdd\u8bc1\u91d1\u4e0d\u80fd\u5173\u8054\u503a\u52a1\u3002", (String)"SuretyBillSubmitValidator_9", (String)"tmc-fbd-business", (Object[])new Object[0]));
            }
            if ((creditNotClose = creditEntry.stream().filter(d -> d.getBoolean("creditbillid.isclose")).collect(Collectors.toList())).size() > 1) {
                this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u4e00\u7b14\u4fdd\u8bc1\u91d1\u5b58\u5165\u5355\u53ea\u80fd\u5173\u8054\u4e00\u7b14\u672a\u5173\u95ed\u7684\u6388\u4fe1\u989d\u5ea6\u5355\u3002", (String)"SuretyBillSubmitValidator_11", (String)"tmc-fbd-business", (Object[])new Object[0]));
            }
            this.checkAccount(extendData, suretyBill);
        }
    }

    private BigDecimal getRate(Long fromCurrencyId, Long tarCurrencyId, Long orgId, Date bizDate) {
        if (fromCurrencyId.equals(tarCurrencyId)) {
            return BigDecimal.ONE;
        }
        BigDecimal rate = TmcBusinessBaseHelper.getExchangeRate((long)fromCurrencyId, (long)tarCurrencyId, (long)orgId, (Date)bizDate);
        if (rate == null) {
            return BigDecimal.ONE;
        }
        return rate;
    }

    private void checkAccount(ExtendedDataEntity extendData, DynamicObject suretyBill) {
        DynamicObject settleAccount = suretyBill.getDynamicObject("settleaccount");
        DynamicObject finaAccount = suretyBill.getDynamicObject("finaccount");
        if (EmptyUtil.isNoEmpty((DynamicObject)settleAccount) && EmptyUtil.isNoEmpty((DynamicObject)finaAccount) && settleAccount.getLong("id") == finaAccount.getLong("id")) {
            this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u6d3b\u671f\u8d26\u6237\u548c\u4fdd\u8bc1\u91d1\u8d26\u6237\u4e0d\u80fd\u76f8\u540c\u3002", (String)"SuretyBillSubmitValidator_13", (String)"tmc-fbd-business", (Object[])new Object[0]));
        }
    }

    private void checkMustInputByInterestType(ExtendedDataEntity extendData, DynamicObject suretyBill) {
        String intType = suretyBill.getString("interesttype");
        Date expireDate = suretyBill.getDate("expiredate");
        if (StringUtils.equals((CharSequence)InterestTypeEnum.FIXED.getValue(), (CharSequence)intType)) {
            BigDecimal depositRate = suretyBill.getBigDecimal("interestrate");
            if (EmptyUtil.isNoEmpty((Object)expireDate) && EmptyUtil.isEmpty((BigDecimal)depositRate)) {
                this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u5b9a\u671f\u5229\u7387\uff08%\uff09\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SuretyBillSubmitValidator_2", (String)"tmc-fbd-business", (Object[])new Object[0]));
            }
        } else if (StringUtils.equals((CharSequence)InterestTypeEnum.FLOAT.getValue(), (CharSequence)intType)) {
            DynamicObject referRate = suretyBill.getDynamicObject("referencerate");
            if (EmptyUtil.isNoEmpty((Object)expireDate) && EmptyUtil.isEmpty((DynamicObject)referRate)) {
                this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u53c2\u8003\u5229\u7387\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SuretyBillSubmitValidator_3", (String)"tmc-fbd-business", (Object[])new Object[0]));
            }
        }
        String revenueWay = suretyBill.getString("revenueway");
        if (!RevenueWayEnum.NOREVENUE.getValue().equals(revenueWay) && EmptyUtil.isEmpty((Object)expireDate) && EmptyUtil.isEmpty((BigDecimal)suretyBill.getBigDecimal("demandrate"))) {
            this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u6d3b\u671f\u5229\u7387\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SuretyBillSubmitValidator_5", (String)"tmc-fbd-business", (Object[])new Object[0]));
        }
    }
}

