/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.validate.surety;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.tmc.fbd.common.enums.DebtBillTypeEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SuretyBillUnAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("id");
        selector.add("suretybill");
        selector.add("entry");
        selector.add("entry.debttype");
        selector.add("entry.debtbillid");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        block0: for (ExtendedDataEntity extendData : dataEntity) {
            DynamicObject suretyBill = extendData.getDataEntity();
            Map targetBills = BFTrackerServiceHelper.findTargetBills((String)suretyBill.getDataEntityType().getName(), (Long[])new Long[]{suretyBill.getLong("id")});
            this.handleTargetBills(targetBills);
            if (null != targetBills && targetBills.size() > 0) {
                this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u5b58\u5728\u4e0b\u6e38\u5355\u636e\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"SuretyBillUnAuditValidator_0", (String)"tmc-fbd-business", (Object[])new Object[0]));
            }
            if (QueryServiceHelper.exists((String)"fbd_surety_append", (QFilter[])new QFilter[]{new QFilter("suretybill", "=", (Object)suretyBill.getLong("id"))})) {
                this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u5b58\u5728\u4e0b\u6e38\u8ffd\u52a0\u5355\u636e\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"SuretyBillUnAuditValidator_1", (String)"tmc-fbd-business", (Object[])new Object[0]));
            }
            DynamicObjectCollection suretyEntry = suretyBill.getDynamicObjectCollection("entry");
            for (DynamicObject suretyDo : suretyEntry) {
                if (!DebtBillTypeEnum.LC_LETTERCREDIT.getValue().equals(suretyDo.getString("debttype"))) continue;
                QFilter debtBillFilter = new QFilter("id", "=", (Object)suretyDo.getLong("debtbillid"));
                DynamicObject letterCreditDo = QueryServiceHelper.queryOne((String)DebtBillTypeEnum.LC_LETTERCREDIT.getValue(), (String)"creditstatus", (QFilter[])debtBillFilter.toArray());
                if (!EmptyUtil.isNoEmpty((DynamicObject)letterCreditDo) || !"done_repeal".equals(letterCreditDo.getString("creditstatus"))) continue;
                this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u8be5\u7b14\u4fdd\u8bc1\u91d1\u5173\u8054\u7684\u4fe1\u7528\u8bc1\u72b6\u6001\u4e3a\u5df2\u64a4\u8bc1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"SuretyBillUnAuditValidator_2", (String)"tmc-fbd-business", (Object[])new Object[0]));
                continue block0;
            }
        }
    }

    private void handleTargetBills(Map<String, HashSet<Long>> targetBills) {
        HashSet<Long> psdSet;
        HashSet<Long> casSet = targetBills.get("cas_paybill");
        if (EmptyUtil.isNoEmpty(casSet) && !QueryServiceHelper.exists((String)"cas_paybill", (QFilter[])new QFilter[]{new QFilter("id", "in", casSet).and("billstatus", "!=", (Object)"G")})) {
            targetBills.remove("cas_paybill");
        }
        if (EmptyUtil.isNoEmpty(psdSet = targetBills.get("psd_schedulebill")) && !QueryServiceHelper.exists((String)"psd_schedulebill", (QFilter[])new QFilter[]{new QFilter("id", "in", psdSet).and("schedulstatus", "!=", (Object)"yetchargeback")})) {
            targetBills.remove("psd_schedulebill");
        }
    }
}

