/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.validate.suretyappend;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SuretyAppendSaveValidator
extends AbstractTmcBizOppValidator {
    private static final String SYSTEM_TYPE = "tmc-fbd-business";

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("appendamount");
        selector.add("appendflag");
        selector.add("entry");
        selector.add("entry.appendamt");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity append : dataEntity) {
            BigDecimal totalAppendAmt;
            DynamicObject appendEntity = append.getDataEntity();
            if (appendEntity.getBoolean("appendflag") || (totalAppendAmt = appendEntity.getDynamicObjectCollection("entry").stream().filter(f -> EmptyUtil.isNoEmpty((BigDecimal)f.getBigDecimal("appendamt"))).map(e -> e.getBigDecimal("appendamt")).reduce(BigDecimal.ZERO, BigDecimal::add)).compareTo(appendEntity.getBigDecimal("appendamount")) <= 0) continue;
            this.addErrorMessage(append, ResManager.loadKDString((String)"\u503a\u52a1\u4fe1\u606f\u5206\u5f55\u8ffd\u52a0\u91d1\u989d\u5408\u8ba1\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u8be5\u5355\u636e\u7684\u8ffd\u52a0\u91d1\u989d\u3002", (String)"SuretyAppendSaveValidator_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
    }
}

