/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.validate.suretypreint;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SuretyPreIntAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("sourcebillid");
        selector.add("prestenddate");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extData : dataEntity) {
            DynamicObject intPreBill = extData.getDataEntity();
            long sourceBillId = intPreBill.getLong("sourcebillid");
            DynamicObject suretyBill = TmcDataServiceHelper.loadSingleFromCache((Object)sourceBillId, (String)"fbd_suretybill", (String)"intdate,endpreinstdate");
            if (EmptyUtil.isEmpty((DynamicObject)suretyBill)) continue;
            Date lastPayIntDate = suretyBill.getDate("endpreinstdate");
            if (EmptyUtil.isNoEmpty((Object)lastPayIntDate)) {
                if (intPreBill.getDate("prestenddate").compareTo(lastPayIntDate) > 0) continue;
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u9884\u63d0\u7ed3\u675f\u65e5\u8981\u5927\u4e8e\u5b58\u6b3e\u5355\u4e0a\u6b21\u9884\u63d0\u7ed3\u675f\u65e5\u3002", (String)"SuretyPreIntAuditValidator_1", (String)"tmc-fbd-business", (Object[])new Object[0]));
                continue;
            }
            Date intDate = suretyBill.getDate("intdate");
            if (intPreBill.getDate("prestenddate").compareTo(intDate) >= 0) continue;
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u9884\u63d0\u7ed3\u675f\u65e5\u8981\u5927\u4e8e\u6216\u7b49\u4e8e\u5b58\u6b3e\u8d77\u606f\u65e5\u3002", (String)"SuretyPreIntAuditValidator_2", (String)"tmc-fbd-business", (Object[])new Object[0]));
        }
    }
}

