/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.validate.suretypreint;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SuretyPreIntBatchSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sid = super.getSelector();
        sid.add("entry");
        sid.add("intbillid");
        sid.add("intdetailnum");
        sid.add("loanbillid");
        return sid;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity intExtend : dataEntity) {
            DynamicObject intRevenue = intExtend.getDataEntity();
            DynamicObjectCollection entrys = intRevenue.getDynamicObjectCollection("entry");
            Set<Long> collect = entrys.stream().map(s -> s.getLong("loanbillid")).collect(Collectors.toSet());
            this.validateOnWayBill(intExtend, collect);
        }
    }

    protected void validateOnWayBill(ExtendedDataEntity intExtend, Set<Long> loanBillIds) {
        QFilter qfilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
        qfilter.and(new QFilter("entry.loanbillid", "in", loanBillIds));
        if (EmptyUtil.isNoEmpty((Object)intExtend.getDataEntity().getPkValue())) {
            qfilter.and(new QFilter("id", "!=", intExtend.getDataEntity().getPkValue()));
        }
        DynamicObjectCollection batchEntryBills = QueryServiceHelper.query((String)"fbd_surety_preint_batch", (String)"entry.id,entry.loanbillid", (QFilter[])qfilter.toArray());
        ArrayList illegalBillIds = new ArrayList();
        batchEntryBills.stream().filter(v -> loanBillIds.contains(v.get("entry.loanbillid"))).forEach(v -> illegalBillIds.add(v.getLong("entry.loanbillid")));
        if (EmptyUtil.isNoEmpty(illegalBillIds)) {
            DynamicObjectCollection inneraccts = QueryServiceHelper.query((String)"fbd_suretybill", (String)"billno", (QFilter[])new QFilter("id", "in", illegalBillIds).toArray());
            StringJoiner sj = new StringJoiner("\uff0c");
            inneraccts.stream().forEach(v -> sj.add(v.getString("billno")));
            this.addErrorMessage(intExtend, this.getExistOnWayDataTip(sj.toString()));
        }
    }

    public String getExistOnWayDataTip(String loanNum) {
        return ResManager.loadKDString((String)"%s\u5b58\u5728\u6b63\u5728\u5904\u7406\u7684\u6279\u91cf\u64cd\u4f5c\uff0c\u8bf7\u5148\u5b8c\u6210\u540e\u518d\u64cd\u4f5c\u3002", (String)"SuretyPreIntBatchSaveValidator_0", (String)"tmc-fbd-business", (Object[])new Object[]{loanNum});
    }
}

