/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.validate.suretypreint;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbd.common.enums.IntDataSource;
import kd.tmc.fbd.common.enums.PreIntOperateTypeEnum;
import kd.tmc.fbd.common.enums.WriteOffStatusEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SuretyPreIntRedWriteOffValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("loanbillno");
        sic.add("prestartdate");
        sic.add("prestenddate");
        sic.add("billstatus");
        sic.add("writeoffpreintbillid");
        sic.add("writeoffstatus");
        sic.add("operatetype");
        sic.add("org");
        sic.add("creditortype");
        sic.add("creditorg");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String message;
            DynamicObject preintBill = dataEntity.getDataEntity();
            if (!PreIntOperateTypeEnum.PREINT.getValue().equals(preintBill.getString("operatetype"))) {
                message = ResManager.loadKDString((String)"\u64cd\u4f5c\u7c7b\u522b\u4e3a\u9884\u63d0\u5229\u606f\u624d\u5141\u8bb8\u7ea2\u5b57\u51b2\u9500\u3002", (String)"SuretyPreIntRedWriteOffValidator_0", (String)"tmc-fbd-business", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, message);
                continue;
            }
            if (!BillStatusEnum.AUDIT.getValue().equals(preintBill.getString("billstatus")) || !WriteOffStatusEnum.NO_WRITEOFF.getValue().equals(preintBill.getString("writeoffstatus"))) {
                message = ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u4e14\u672a\u51b2\u9500\u5355\u636e\u624d\u5141\u8bb8\u51b2\u9500\u3002", (String)"SuretyPreIntRedWriteOffValidator_1", (String)"tmc-fbd-business", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, message);
            }
            String loanbillno = preintBill.getString("loanbillno");
            QFilter loanbillnoFilter = new QFilter("loanbillno", "=", (Object)loanbillno);
            loanbillnoFilter.and(new QFilter("writeoffstatus", "=", (Object)WriteOffStatusEnum.NO_WRITEOFF.getValue()));
            loanbillnoFilter.and(new QFilter("operatetype", "=", (Object)PreIntOperateTypeEnum.PREINT.getValue()));
            loanbillnoFilter.and(new QFilter("datasource", "=", (Object)IntDataSource.PREINT.getValue()));
            DynamicObjectCollection preInterestBills = QueryServiceHelper.query((String)"fbd_surety_preint", (String)"id", (QFilter[])new QFilter[]{loanbillnoFilter}, (String)"prestartdate  desc");
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)preInterestBills) || ((DynamicObject)preInterestBills.get(0)).get("id").equals(preintBill.getPkValue())) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u662f\u6700\u540e\u4e00\u7b14\u9884\u63d0\u5229\u606f\u5355\u4e0d\u5141\u8bb8\u7ea2\u5b57\u51b2\u9500\u3002", (String)"SuretyPreIntRedWriteOffValidator_2", (String)"tmc-fbd-business", (Object[])new Object[0]));
        }
    }
}

