/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.validate.suretystlint;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbd.common.enums.RevenueTypeEnum;
import kd.tmc.fbd.common.helper.SuretyIntCalcHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SuretySettleIntAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sid = super.getSelector();
        sid.add("revenuetype");
        sid.add("prestartdate");
        sid.add("sourcebillid");
        return sid;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            Date beginDate;
            QFilter idFilter;
            DynamicObject suretyBill;
            Date startInstDate;
            DynamicObject revenue = dataEntity.getDataEntity();
            Map variables = this.getOption().getVariables();
            if (variables.containsKey("releaseAudit")) continue;
            String revenueType = revenue.getString("revenuetype");
            if (RevenueTypeEnum.RELEASE_REV.getValue().equals(revenueType)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u51fa\u6536\u76ca\u7c7b\u578b\u7684\u6536\u76ca\u5355\u636e\u6b64\u5904\u4e0d\u5141\u8bb8\u5ba1\u6838\u3002", (String)"SuretySettleIntAuditValidator_1", (String)"tmc-fbd-business", (Object[])new Object[0]));
            }
            if (!EmptyUtil.isNoEmpty((Object)(startInstDate = revenue.getDate("prestartdate"))) || !EmptyUtil.isNoEmpty((DynamicObject)(suretyBill = QueryServiceHelper.queryOne((String)"fbd_suretybill", (String)"id,endinstdate,org,intdate", (QFilter[])(idFilter = new QFilter("id", "=", (Object)revenue.getLong("sourcebillid"))).toArray()))) || startInstDate.compareTo(beginDate = SuretyIntCalcHelper.getBeginIntDate((DynamicObject)suretyBill)) == 0) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u76ca\u5355\u8d77\u606f\u65e5\u53d1\u751f\u4e86\u53d8\u5316\uff0c\u8bf7\u5728\u5355\u636e\u9875\u9762\u786e\u8ba4\u540e\u63d0\u4ea4\u3002", (String)"SuretySettleIntSubmitValidator_4", (String)"tmc-fbd-business", (Object[])new Object[0]));
        }
    }
}

