/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.validate.suretystlint;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbd.common.enums.IntDataSource;
import kd.tmc.fbd.common.enums.RevenueTypeEnum;
import kd.tmc.fbd.common.helper.SuretyIntCalcHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SuretySettleIntSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sid = super.getSelector();
        sid.add("expiredate");
        sid.add("prestartdate");
        sid.add("sourcebillid");
        sid.add("org");
        sid.add("endinstdate");
        return sid;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        List<Long> repeatList = this.validRepeatSubmit(dataEntities);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            Date beginDate;
            Date startInstDate;
            QFilter saveFilter;
            boolean existsSave;
            QFilter idFilter;
            DynamicObject suretyBill;
            Long sourceBillId;
            DynamicObject revenue = dataEntity.getDataEntity();
            String revenueType = revenue.getString("revenuetype");
            if (RevenueTypeEnum.RELEASE_REV.getValue().equals(revenueType)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u51fa\u6536\u76ca\u7c7b\u578b\u7684\u6536\u76ca\u5355\u636e\u6b64\u5904\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"SuretySettleIntSubmitValidator_5", (String)"tmc-fbd-business", (Object[])new Object[0]));
                continue;
            }
            Date expireDate = revenue.getDate("expiredate");
            Date revenueStartDate = revenue.getDate("prestartdate");
            if (EmptyUtil.isNoEmpty((Object)expireDate) && EmptyUtil.isNoEmpty((Object)revenueStartDate) && expireDate.compareTo(revenueStartDate) <= 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5230\u671f\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u8d77\u606f\u65e5\u3002", (String)"SuretySettleIntSaveValidator_0", (String)"tmc-fbd-business", (Object[])new Object[0]));
            }
            if (repeatList.contains(sourceBillId = Long.valueOf(revenue.getLong("sourcebillid")))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u540c\u4e00\u4fdd\u8bc1\u91d1\u5b58\u5165\u5355\u4e0b\u7684\u6536\u76ca\u5355\u4e0d\u5141\u8bb8\u6279\u91cf\u63d0\u4ea4\u3002", (String)"SuretySettleIntSubmitValidator_1", (String)"tmc-fbd-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isEmpty((DynamicObject)(suretyBill = QueryServiceHelper.queryOne((String)"fbd_suretybill", (String)"id,billno,endinstdate,org,intdate", (QFilter[])(idFilter = new QFilter("id", "=", (Object)sourceBillId)).toArray())))) continue;
            QFilter qFilter = new QFilter("loanbillno", "=", (Object)suretyBill.getString("billno"));
            qFilter.and(new QFilter("datasource", "=", (Object)IntDataSource.SETTLEINT.getValue()));
            QFilter submitFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.SUBMIT.getValue());
            DynamicObject submitRev = TmcDataServiceHelper.loadSingle((String)"fbd_surety_settleint", (String)"billno", (QFilter[])qFilter.and(submitFilter).toArray());
            if (EmptyUtil.isNoEmpty((DynamicObject)submitRev)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fdd\u8bc1\u91d1\u5b58\u5165\u5355\u5b58\u5728\u5df2\u63d0\u4ea4\u7684\u6536\u76ca\u5355%s\uff0c\u8bf7\u5148\u5ba1\u6838\u6216\u64a4\u9500\u3002", (String)"SuretySettleIntSubmitValidator_2", (String)"tmc-fbd-business", (Object[])new Object[]{submitRev.getString("billno")}));
            }
            if (existsSave = TmcDataServiceHelper.exists((String)"fbd_surety_settleint", (QFilter[])qFilter.and(saveFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue())).toArray())) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u6536\u76ca\u5355\u5b58\u5728\u5176\u5b83\u6682\u5b58\u72b6\u6001\u7684\u6536\u76ca\u8bb0\u5f55\uff0c\u662f\u5426\u7ee7\u7eed\u63d0\u4ea4\u5f53\u524d\u6536\u76ca\u5355\uff1f", (String)"SuretySettleIntSubmitValidator_3", (String)"tmc-fbd-business", (Object[])new Object[0]), ErrorLevel.Warning);
            }
            if (!EmptyUtil.isNoEmpty((Object)(startInstDate = revenue.getDate("prestartdate"))) || startInstDate.compareTo(beginDate = SuretyIntCalcHelper.getBeginIntDate((DynamicObject)suretyBill)) == 0) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u76ca\u5355\u8d77\u606f\u65e5\u53d1\u751f\u4e86\u53d8\u5316\uff0c\u8bf7\u5728\u5355\u636e\u9875\u9762\u786e\u8ba4\u540e\u63d0\u4ea4\u3002", (String)"SuretySettleIntSubmitValidator_4", (String)"tmc-fbd-business", (Object[])new Object[0]));
        }
    }

    private List<Long> validRepeatSubmit(ExtendedDataEntity[] dataEntities) {
        int length = dataEntities.length;
        ArrayList<Long> repeatList = new ArrayList<Long>(length);
        if (EmptyUtil.isEmpty((Object[])dataEntities)) {
            return repeatList;
        }
        ArrayList<Long> exitsList = new ArrayList<Long>(length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject revenue = dataEntity.getDataEntity();
            Long sourceBillId = revenue.getLong("sourcebillid");
            if (exitsList.contains(sourceBillId)) {
                repeatList.add(sourceBillId);
            }
            exitsList.add(sourceBillId);
        }
        return repeatList;
    }
}

